/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ThresholdMixin;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaximumValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MaximumValidator.class);
    private static final String PROPERTY_EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private boolean excludeEqual = false;
    private final ThresholdMixin typedMaximum;

    public MaximumValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAXIMUM, validationContext);
        if (!schemaNode.isNumber()) {
            throw new JsonSchemaException("maximum value is not a number");
        }
        JsonNode exclusiveMaximumNode = this.getParentSchema().getSchemaNode().get(PROPERTY_EXCLUSIVE_MAXIMUM);
        if (exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean()) {
            this.excludeEqual = exclusiveMaximumNode.booleanValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        if (!JsonType.INTEGER.toString().equals(this.getNodeFieldType())) {
            final double dm = schemaNode.doubleValue();
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    double value = node.asDouble();
                    return MaximumValidator.this.greaterThan(value, dm) || MaximumValidator.this.excludeEqual && MaximumValidator.this.equals(value, dm);
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(dm);
                }
            };
        } else if (schemaNode.isLong() || schemaNode.isInt()) {
            final long lm = schemaNode.asLong();
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    long val = node.asLong();
                    return node.isBigInteger() || lm < val || MaximumValidator.this.excludeEqual && lm <= val;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(lm);
                }
            };
        } else {
            final BigInteger bim = new BigInteger(schemaNode.asText());
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    int cmp = bim.compareTo(node.bigIntegerValue());
                    return cmp < 0 || MaximumValidator.this.excludeEqual && cmp <= 0;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(bim);
                }
            };
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (!TypeValidator.isNumber(node, this.config.isTypeLoose())) {
            return Collections.emptySet();
        }
        if (this.typedMaximum.crossesThreshold(node)) {
            return Collections.singleton(this.buildValidationMessage(at, this.typedMaximum.thresholdValue()));
        }
        return Collections.emptySet();
    }
}

