/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.RefValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(OneOfValidator.class);
    private final List<ShortcutValidator> schemas = new ArrayList<ShortcutValidator>();

    public OneOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = schemaNode.get(i);
            JsonSchema childSchema = new JsonSchema(validationContext, parentSchema.getSchemaPath() + "/" + this.getValidatorType().getValue() + "/" + i, parentSchema.getCurrentUri(), childNode, parentSchema);
            this.schemas.add(new ShortcutValidator(childNode, parentSchema, validationContext, childSchema));
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        Set<ValidationMessage> set;
        block17: {
            Object backupEvaluatedProperties;
            block16: {
                List backupEvaluatedPropertiesList;
                LinkedHashSet<Object> errors = new LinkedHashSet<Object>();
                backupEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                try {
                    this.debug(logger, node, rootNode, at);
                    ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
                    state.setComplexValidator(true);
                    int numberOfValidSchema = 0;
                    Set<Object> childErrors = new LinkedHashSet();
                    for (ShortcutValidator validator : this.schemas) {
                        Set<ValidationMessage> schemaErrors = null;
                        state.setMatchedNode(true);
                        JsonSchema schema = validator.schema;
                        schemaErrors = !state.isWalkEnabled() ? schema.validate(node, rootNode, at) : schema.walk(node, rootNode, at, state.isValidationEnabled());
                        if (schemaErrors.isEmpty()) {
                            if (!state.hasMatchedNode()) continue;
                            ++numberOfValidSchema;
                        }
                        if (numberOfValidSchema > 1) {
                            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                            break;
                        }
                        childErrors.addAll(schemaErrors);
                    }
                    Set childNotRequiredErrors = childErrors.stream().filter(error -> !ValidatorTypeCode.REQUIRED.getValue().equals(error.getType())).collect(Collectors.toSet());
                    if (numberOfValidSchema > 1) {
                        ValidationMessage message = this.getMultiSchemasValidErrorMsg(at);
                        if (this.failFast) {
                            throw new JsonSchemaException(message);
                        }
                        errors.add(message);
                    } else if (numberOfValidSchema < 1) {
                        if (!childNotRequiredErrors.isEmpty()) {
                            childErrors = childNotRequiredErrors;
                        }
                        if (!childErrors.isEmpty()) {
                            LinkedHashSet notAdditionalPropertiesOnly;
                            if (childErrors.size() > 1 && (notAdditionalPropertiesOnly = new LinkedHashSet(childErrors.stream().filter(validationMessage -> !ValidatorTypeCode.ADDITIONAL_PROPERTIES.getValue().equals(validationMessage.getType())).sorted((vm1, vm2) -> OneOfValidator.compareValidationMessages(vm1, vm2)).collect(Collectors.toList()))).size() > 0) {
                                childErrors = notAdditionalPropertiesOnly;
                            }
                            errors.addAll(childErrors);
                        }
                        if (this.failFast) {
                            throw new JsonSchemaException(((Object)errors).toString());
                        }
                    }
                    if (errors.isEmpty()) {
                        state.setMatchedNode(true);
                    }
                    this.resetValidatorState();
                    set = Collections.unmodifiableSet(errors);
                    if (!errors.isEmpty()) break block16;
                    backupEvaluatedPropertiesList = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                }
                catch (Throwable throwable) {
                    if (errors.isEmpty()) {
                        List backupEvaluatedPropertiesList2 = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                        backupEvaluatedPropertiesList2.addAll((List)CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties"));
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList2);
                    } else {
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
                    }
                    throw throwable;
                }
                backupEvaluatedPropertiesList.addAll((List)CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties"));
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList);
                break block17;
            }
            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
        }
        return set;
    }

    private static int compareValidationMessages(ValidationMessage vm1, ValidationMessage vm2) {
        List<String> typeCodes = Arrays.asList(ValidatorTypeCode.TYPE.getValue(), ValidatorTypeCode.DATETIME.getValue(), ValidatorTypeCode.UUID.getValue(), ValidatorTypeCode.ID.getValue(), ValidatorTypeCode.EXCLUSIVE_MAXIMUM.getValue(), ValidatorTypeCode.EXCLUSIVE_MINIMUM.getValue(), ValidatorTypeCode.TRUE.getValue(), ValidatorTypeCode.FALSE.getValue(), ValidatorTypeCode.CONST.getValue(), ValidatorTypeCode.CONTAINS.getValue(), ValidatorTypeCode.PROPERTYNAMES.getValue());
        int index1 = typeCodes.indexOf(vm1.getType());
        int index2 = typeCodes.indexOf(vm2.getType());
        if (index1 >= 0) {
            if (index2 >= 0) {
                return Integer.compare(index1, index2);
            }
            return -1;
        }
        if (index2 >= 0) {
            return 1;
        }
        return vm1.getCode().compareTo(vm2.getCode());
    }

    private void resetValidatorState() {
        ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
        state.setComplexValidator(false);
        state.setMatchedNode(true);
    }

    public List<JsonSchema> getChildSchemas() {
        ArrayList<JsonSchema> childJsonSchemas = new ArrayList<JsonSchema>();
        for (ShortcutValidator shortcutValidator : this.schemas) {
            childJsonSchemas.add(shortcutValidator.getSchema());
        }
        return childJsonSchemas;
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages.addAll(this.validate(node, rootNode, at));
        } else {
            for (ShortcutValidator validator : this.schemas) {
                validator.schema.walk(node, rootNode, at, shouldValidateSchema);
            }
        }
        return validationMessages;
    }

    private ValidationMessage getMultiSchemasValidErrorMsg(String at) {
        String msg = "";
        for (ShortcutValidator schema : this.schemas) {
            String schemaValue = schema.getSchema().getSchemaNode().toString();
            msg = msg.concat(schemaValue);
        }
        return ValidationMessage.of(this.getValidatorType().getValue(), (ErrorMessageType)ValidatorTypeCode.ONE_OF, at, this.schemaPath, msg);
    }

    @Override
    public void preloadJsonSchema() {
        for (ShortcutValidator scValidator : this.schemas) {
            scValidator.getSchema().initializeValidators();
        }
    }

    private static class ShortcutValidator {
        private final JsonSchema schema;
        private final Map<String, String> constants;

        ShortcutValidator(JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, JsonSchema schema) {
            JsonNode refNode = schemaNode.get(ValidatorTypeCode.REF.getValue());
            JsonSchema resolvedRefSchema = refNode != null && refNode.isTextual() ? RefValidator.getRefSchema(parentSchema, validationContext, refNode.textValue()).getSchema() : null;
            this.constants = this.extractConstants(schemaNode, resolvedRefSchema);
            this.schema = schema;
        }

        private Map<String, String> extractConstants(JsonNode schemaNode, JsonSchema resolvedRefSchema) {
            Map<String, String> refMap = resolvedRefSchema != null ? this.extractConstants(resolvedRefSchema.getSchemaNode()) : Collections.emptyMap();
            Map<String, String> schemaMap = this.extractConstants(schemaNode);
            if (refMap.isEmpty()) {
                return schemaMap;
            }
            if (schemaMap.isEmpty()) {
                return refMap;
            }
            HashMap<String, String> joined = new HashMap<String, String>();
            joined.putAll(schemaMap);
            joined.putAll(refMap);
            return joined;
        }

        private Map<String, String> extractConstants(JsonNode schemaNode) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (!schemaNode.isObject()) {
                return result;
            }
            JsonNode propertiesNode = schemaNode.get("properties");
            if (propertiesNode == null || !propertiesNode.isObject()) {
                return result;
            }
            Iterator fit = propertiesNode.fieldNames();
            while (fit.hasNext()) {
                String fieldName = (String)fit.next();
                JsonNode jsonNode = propertiesNode.get(fieldName);
                String constantFieldValue = this.getConstantFieldValue(jsonNode);
                if (constantFieldValue == null || constantFieldValue.isEmpty()) continue;
                result.put(fieldName, constantFieldValue);
            }
            return result;
        }

        private String getConstantFieldValue(JsonNode jsonNode) {
            if (jsonNode == null || !jsonNode.isObject() || !jsonNode.has("enum")) {
                return null;
            }
            JsonNode enumNode = jsonNode.get("enum");
            if (enumNode == null || !enumNode.isArray()) {
                return null;
            }
            if (enumNode.size() != 1) {
                return null;
            }
            JsonNode valueNode = enumNode.get(0);
            if (valueNode == null || !valueNode.isTextual()) {
                return null;
            }
            return valueNode.textValue();
        }

        public boolean allConstantsMatch(JsonNode node) {
            for (Map.Entry<String, String> e : this.constants.entrySet()) {
                boolean match;
                JsonNode valueNode = node.get(e.getKey());
                if (valueNode == null || !valueNode.isTextual() || (match = e.getValue().equals(valueNode.textValue()))) continue;
                return false;
            }
            return true;
        }

        private JsonSchema getSchema() {
            return this.schema;
        }
    }
}

