/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyNamesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(PropertyNamesValidator.class);
    private Map<String, JsonSchema> schemas;
    private boolean schemaValue = false;

    public PropertyNamesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTYNAMES, validationContext);
        if (schemaNode.isBoolean()) {
            this.schemaValue = schemaNode.booleanValue();
        } else {
            this.schemas = new HashMap<String, JsonSchema>();
            Iterator it = schemaNode.fieldNames();
            while (it.hasNext()) {
                String pname = (String)it.next();
                this.schemas.put(pname, new JsonSchema(validationContext, schemaPath + "/" + pname, parentSchema.getCurrentUri(), schemaNode.get(pname), parentSchema));
            }
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (this.schemas != null) {
            for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
                JsonNode propertyNode = node.get(entry.getKey());
                if (!node.isObject()) continue;
                Iterator it = node.fieldNames();
                while (it.hasNext()) {
                    String pname = (String)it.next();
                    int maxLength = entry.getValue().getSchemaNode().intValue();
                    if ("maxLength".equals(entry.getKey()) && pname.length() > maxLength) {
                        errors.add(this.buildValidationMessage(at + "." + pname, "maxLength " + maxLength));
                    }
                    int minLength = entry.getValue().getSchemaNode().intValue();
                    if ("minLength".equals(entry.getKey()) && pname.length() < minLength) {
                        errors.add(this.buildValidationMessage(at + "." + pname, "minLength " + minLength));
                    }
                    String pattern = entry.getValue().getSchemaNode().textValue();
                    if (!"pattern".equals(entry.getKey()) || Pattern.matches(pattern, pname)) continue;
                    errors.add(this.buildValidationMessage(at + "." + pname, "pattern " + pattern));
                }
            }
        } else if (!this.schemaValue && node.isObject() && node.size() != 0) {
            errors.add(this.buildValidationMessage(at + "." + node, "false"));
        }
        return Collections.unmodifiableSet(errors);
    }
}

