/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Collector;
import com.networknt.schema.ThreadInfo;
import java.util.HashMap;
import java.util.Map;

public class CollectorContext {
    static final String COLLECTOR_CONTEXT_THREAD_LOCAL_KEY = "COLLECTOR_CONTEXT_THREAD_LOCAL_KEY";
    private Map<String, Collector<?>> collectorMap = new HashMap();
    private Map<String, Object> collectorLoadMap = new HashMap<String, Object>();

    public static CollectorContext getInstance() {
        return (CollectorContext)ThreadInfo.get(COLLECTOR_CONTEXT_THREAD_LOCAL_KEY);
    }

    public <E> void add(String collectorType, Collector<E> collector) {
        this.collectorMap.put(collectorType, collector);
    }

    public Object get(String collectorType) {
        if (this.collectorLoadMap.get(collectorType) == null && this.collectorMap.get(collectorType) != null) {
            this.collectorLoadMap.put(collectorType, this.collectorMap.get(collectorType).collect());
        }
        return this.collectorLoadMap.get(collectorType);
    }

    void load() {
        for (Map.Entry<String, Collector<?>> collectorEntrySet : this.collectorMap.entrySet()) {
            this.collectorLoadMap.put(collectorEntrySet.getKey(), collectorEntrySet.getValue().collect());
        }
    }

    void reset() {
        this.collectorMap = new HashMap();
        this.collectorLoadMap = new HashMap<String, Object>();
    }
}

