/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionTypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnionTypeValidator.class);
    private List<JsonValidator> schemas = new ArrayList<JsonValidator>();
    private String error;

    public UnionTypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNION_TYPE);
        String sep = "";
        this.error = "[";
        if (!schemaNode.isArray()) {
            throw new JsonSchemaException("Expected array for type property on Union Type Definition.");
        }
        int i = 0;
        for (JsonNode n : schemaNode) {
            JsonType t = TypeFactory.getSchemaNodeType(n);
            this.error = this.error + sep + (Object)((Object)t);
            sep = ", ";
            if (n.isObject()) {
                this.schemas.add(new JsonSchema(mapper, ValidatorTypeCode.TYPE.getValue(), n, parentSchema));
            } else {
                this.schemas.add(new TypeValidator(schemaPath + "/" + i, n, parentSchema, mapper));
            }
            ++i;
        }
        this.error = this.error + "]";
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        HashSet<ValidationMessage> _return = new HashSet<ValidationMessage>();
        boolean valid = false;
        for (JsonValidator schema : this.schemas) {
            Set<ValidationMessage> errors = schema.validate(node, rootNode, at);
            if (errors != null && errors.size() != 0) continue;
            valid = true;
            break;
        }
        if (!valid) {
            _return.add(this.buildValidationMessage(at, nodeType.toString(), this.error));
        }
        return _return;
    }
}

