/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.url.URLFactory;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchema schema;
    private final String REF_DOMAIN = "/";
    private final String REF_CURRENT = "#";
    private final String REF_RELATIVE = "../";

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        if (!refValue.startsWith("#")) {
            String schemaUrl = refValue;
            int index = refValue.indexOf("#");
            if (index > 0) {
                schemaUrl = schemaUrl.substring(0, index);
            }
            if (this.isRelativePath(schemaUrl)) {
                schemaUrl = this.obtainAbsolutePath(parentSchema, schemaUrl);
            }
            try {
                URL url = URLFactory.toURL(schemaUrl);
                parentSchema = validationContext.getJsonSchemaFactory().getSchema(url);
            }
            catch (MalformedURLException e) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaUrl);
                parentSchema = validationContext.getJsonSchemaFactory().getSchema(is);
            }
            if (index < 0) {
                this.schema = parentSchema.findAncestor();
            } else {
                refValue = refValue.substring(index);
            }
        }
        if (refValue.equals("#")) {
            this.schema = parentSchema.findAncestor();
        } else {
            JsonNode node = parentSchema.getRefSchemaNode(refValue);
            if (node != null) {
                this.schema = new JsonSchema(validationContext, refValue, node, parentSchema);
            }
        }
    }

    private boolean isRelativePath(String schemaUrl) {
        return !schemaUrl.startsWith("http");
    }

    private String obtainAbsolutePath(JsonSchema parentSchema, String schemaUrl) {
        String baseSchemaUrl = parentSchema.findAncestor().getSchemaNode().get("id").textValue();
        int index = baseSchemaUrl.lastIndexOf("/");
        baseSchemaUrl = baseSchemaUrl.substring(0, index);
        String schemaRef = schemaUrl;
        if (schemaRef.startsWith("/")) {
            try {
                URL url = URLFactory.toURL(baseSchemaUrl);
                baseSchemaUrl = url.getProtocol() + "//" + url.getHost();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else if (schemaRef.startsWith("../")) {
            while (schemaRef.startsWith("../")) {
                index = baseSchemaUrl.lastIndexOf("/");
                baseSchemaUrl = baseSchemaUrl.substring(0, index);
                schemaRef = schemaRef.replaceFirst("../", "");
            }
        }
        schemaRef = baseSchemaUrl + "/" + schemaRef;
        return schemaRef;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.schema != null) {
            return this.schema.validate(node, rootNode, at);
        }
        return Collections.emptySet();
    }
}

