/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.url.StandardURLFetcher;
import com.networknt.schema.url.URLFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaFactory.class);
    private final ObjectMapper mapper;
    private final URLFetcher urlFetcher;
    private final String defaultMetaSchemaURI;
    private final Map<String, JsonMetaSchema> jsonMetaSchemas;

    private JsonSchemaFactory(ObjectMapper mapper, URLFetcher urlFetcher, String defaultMetaSchemaURI, Map<String, JsonMetaSchema> jsonMetaSchemas) {
        if (mapper == null) {
            throw new IllegalArgumentException("ObjectMapper must not be null");
        }
        if (urlFetcher == null) {
            throw new IllegalArgumentException("URLFetcher must not be null");
        }
        if (defaultMetaSchemaURI == null || defaultMetaSchemaURI.trim().isEmpty()) {
            throw new IllegalArgumentException("defaultMetaSchemaURI must not be null or empty");
        }
        if (jsonMetaSchemas == null || jsonMetaSchemas.isEmpty()) {
            throw new IllegalArgumentException("Json Meta Schemas must not be null or empty");
        }
        if (jsonMetaSchemas.get(defaultMetaSchemaURI) == null) {
            throw new IllegalArgumentException("Meta Schema for default Meta Schema URI must be provided");
        }
        this.mapper = mapper;
        this.defaultMetaSchemaURI = defaultMetaSchemaURI;
        this.urlFetcher = urlFetcher;
        this.jsonMetaSchemas = jsonMetaSchemas;
    }

    static Builder builder() {
        return new Builder();
    }

    public static JsonSchemaFactory getInstance() {
        JsonMetaSchema draftV4 = JsonMetaSchema.getDraftV4();
        return JsonSchemaFactory.builder().defaultMetaSchemaURI(draftV4.getUri()).addMetaSchema(draftV4).build();
    }

    public static Builder builder(JsonSchemaFactory blueprint) {
        return JsonSchemaFactory.builder().addMetaSchemas(blueprint.jsonMetaSchemas.values()).urlFetcher(blueprint.urlFetcher).defaultMetaSchemaURI(blueprint.defaultMetaSchemaURI).objectMapper(blueprint.mapper);
    }

    private JsonSchema newJsonSchema(JsonNode schemaNode) {
        ValidationContext validationContext = this.createValidationContext(schemaNode);
        return new JsonSchema(validationContext, schemaNode);
    }

    protected ValidationContext createValidationContext(JsonNode schemaNode) {
        JsonMetaSchema jsonMetaSchema = this.findMetaSchemaForSchema(schemaNode);
        return new ValidationContext(jsonMetaSchema, this);
    }

    private JsonMetaSchema findMetaSchemaForSchema(JsonNode schemaNode) {
        JsonNode uriNode = schemaNode.get("$schema");
        String uri = uriNode == null || uriNode.isNull() ? this.defaultMetaSchemaURI : uriNode.textValue();
        JsonMetaSchema jsonMetaSchema = this.jsonMetaSchemas.get(uri);
        if (jsonMetaSchema == null) {
            throw new JsonSchemaException("Unknown Metaschema: " + uri);
        }
        return jsonMetaSchema;
    }

    public JsonSchema getSchema(String schema) {
        try {
            JsonNode schemaNode = this.mapper.readTree(schema);
            return this.newJsonSchema(schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(InputStream schemaStream) {
        try {
            JsonNode schemaNode = this.mapper.readTree(schemaStream);
            return this.newJsonSchema(schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonSchema getSchema(URL schemaURL) {
        try {
            InputStream inputStream = null;
            try {
                inputStream = this.urlFetcher.fetch(schemaURL);
                JsonNode schemaNode = this.mapper.readTree(inputStream);
                JsonMetaSchema jsonMetaSchema = this.findMetaSchemaForSchema(schemaNode);
                if (this.idMatchesSourceUrl(jsonMetaSchema, schemaNode, schemaURL)) {
                    JsonSchema jsonSchema2 = new JsonSchema(new ValidationContext(jsonMetaSchema, this), schemaNode, null);
                    return jsonSchema2;
                }
                JsonSchema jsonSchema = this.newJsonSchema(schemaNode);
                return jsonSchema;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(JsonNode jsonNode) {
        return this.newJsonSchema(jsonNode);
    }

    private boolean idMatchesSourceUrl(JsonMetaSchema metaSchema, JsonNode schema, URL schemaUrl) {
        String id = metaSchema.readId(schema);
        if (id == null || id.isEmpty()) {
            return false;
        }
        boolean result = id.equals(schemaUrl.toString());
        if (logger.isDebugEnabled()) {
            logger.debug("Matching " + id + " to " + schemaUrl.toString() + ": " + result);
        }
        return result;
    }

    public static class Builder {
        private ObjectMapper objectMapper = new ObjectMapper();
        private URLFetcher urlFetcher;
        private String defaultMetaSchemaURI;
        private Map<String, JsonMetaSchema> jsonMetaSchemas = new HashMap<String, JsonMetaSchema>();

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder urlFetcher(URLFetcher urlFetcher) {
            this.urlFetcher = urlFetcher;
            return this;
        }

        public Builder defaultMetaSchemaURI(String defaultMetaSchemaURI) {
            this.defaultMetaSchemaURI = defaultMetaSchemaURI;
            return this;
        }

        public Builder addMetaSchema(JsonMetaSchema jsonMetaSchema) {
            this.jsonMetaSchemas.put(jsonMetaSchema.getUri(), jsonMetaSchema);
            return this;
        }

        public Builder addMetaSchemas(Collection<? extends JsonMetaSchema> jsonMetaSchemas) {
            for (JsonMetaSchema jsonMetaSchema : jsonMetaSchemas) {
                this.jsonMetaSchemas.put(jsonMetaSchema.getUri(), jsonMetaSchema);
            }
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this.objectMapper == null ? new ObjectMapper() : this.objectMapper, this.urlFetcher == null ? new StandardURLFetcher() : this.urlFetcher, this.defaultMetaSchemaURI, this.jsonMetaSchemas);
        }
    }
}

