/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaFactory.class);
    private ObjectMapper mapper;

    public JsonSchemaFactory() {
        this(new ObjectMapper());
    }

    public JsonSchemaFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public JsonSchema getSchema(String schema) {
        try {
            JsonNode schemaNode = this.mapper.readTree(schema);
            return new JsonSchema(this.mapper, schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(InputStream schemaStream) {
        try {
            JsonNode schemaNode = this.mapper.readTree(schemaStream);
            return new JsonSchema(this.mapper, schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(URL schemaURL) {
        try {
            JsonNode schemaNode = this.mapper.readTree(schemaURL.openStream());
            return new JsonSchema(this.mapper, schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }
}

