/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchema
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchema.class);
    private static final Pattern intPattern = Pattern.compile("^[0-9]+$");
    protected Map<String, JsonValidator> validators;
    private ObjectMapper mapper;

    JsonSchema(ObjectMapper mapper, JsonNode schemaNode) {
        this(mapper, "#", schemaNode, null);
    }

    JsonSchema(ObjectMapper mapper, String schemaPath, JsonNode schemaNode, JsonSchema parent) {
        super(schemaPath, schemaNode, parent, null);
        this.mapper = mapper;
        this.validators = new LinkedHashMap<String, JsonValidator>();
        this.read(schemaNode);
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findAncestor();
        JsonNode node = schema.getSchemaNode();
        if (ref.startsWith("#/")) {
            String[] keys;
            for (String key : keys = ref.substring(2).split("/")) {
                try {
                    key = URLDecoder.decode(key, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                Matcher matcher = intPattern.matcher(key);
                node = matcher.matches() ? node.get(Integer.parseInt(key)) : node.get(key);
                if (node == null) break;
            }
        }
        return node;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private void read(JsonNode schemaNode) {
        Iterator pnames = schemaNode.fieldNames();
        while (pnames.hasNext()) {
            String pname = (String)pnames.next();
            JsonNode n = schemaNode.get(pname);
            String shortClassName = pname;
            if (shortClassName.startsWith("$")) {
                shortClassName = shortClassName.substring(1);
            }
            try {
                ValidatorTypeCode.fromValue(shortClassName);
                String className = Character.toUpperCase(shortClassName.charAt(0)) + shortClassName.substring(1) + "Validator";
                Class<?> clazz = Class.forName("com.networknt.schema." + className);
                Constructor<?> c = null;
                c = clazz.getConstructor(String.class, JsonNode.class, JsonSchema.class, ObjectMapper.class);
                this.validators.put(this.getSchemaPath() + "/" + pname, (JsonValidator)c.newInstance(this.getSchemaPath() + "/" + pname, n, this, this.mapper));
            }
            catch (IllegalArgumentException className) {
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof JsonSchemaException) {
                    throw (JsonSchemaException)e.getTargetException();
                }
                logger.info("Could not load validator " + pname);
            }
            catch (Exception e) {
                logger.info("Could not load validator " + pname);
            }
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode JsonNode2, JsonNode rootNode, String at) {
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        for (JsonValidator v : this.validators.values()) {
            errors.addAll(v.validate(JsonNode2, rootNode, at));
        }
        return errors;
    }

    public String toString() {
        return "\"" + this.getSchemaPath() + "\" : " + this.getSchemaNode().toString();
    }
}

