/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.model;

import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.controllers.model.TaggedDataPoints;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MetricValues {
    private String kind;
    private List<TaggedDataPoints> dataPoints;

    public String getKind() {
        return this.kind;
    }

    public Iterable<TaggedDataPoints> getValues() {
        return this.dataPoints;
    }

    public void addMeasurement(Measurement measurement) {
        this.dataPoints.add(new TaggedDataPoints(measurement));
    }

    public MetricValues(String kind, Measurement measurement) {
        this.kind = kind;
        this.dataPoints = new ArrayList<TaggedDataPoints>();
        this.dataPoints.add(new TaggedDataPoints(measurement));
    }

    public MetricValues(String kind, List<TaggedDataPoints> dataPoints) {
        this.kind = kind;
        this.dataPoints = new ArrayList<TaggedDataPoints>(dataPoints);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MetricValues)) {
            return false;
        }
        MetricValues other = (MetricValues)obj;
        return this.dataPoints.equals(other.dataPoints);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.dataPoints);
    }

    public String toString() {
        return String.format("%s: %s", this.kind, this.dataPoints);
    }
}

