/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.netflix.spectator.api.RegistryConfig;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;

public interface StatelessConfig
extends RegistryConfig {
    default public boolean enabled() {
        String v = this.get("stateless.enabled");
        return v == null || Boolean.parseBoolean(v);
    }

    default public Duration frequency() {
        String v = this.get("stateless.frequency");
        return v == null ? Duration.ofSeconds(5L) : Duration.parse(v);
    }

    default public Duration meterTTL() {
        String v = this.get("stateless.meterTTL");
        return v == null ? Duration.ofMinutes(15L) : Duration.parse(v);
    }

    default public Duration connectTimeout() {
        String v = this.get("stateless.connectTimeout");
        return v == null ? Duration.ofSeconds(1L) : Duration.parse(v);
    }

    default public Duration readTimeout() {
        String v = this.get("stateless.readTimeout");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public String uri() {
        String v = this.get("stateless.uri");
        return v == null ? "http://localhost:7101/api/v4/update" : v;
    }

    default public int batchSize() {
        String v = this.get("stateless.batchSize");
        return v == null ? 10000 : Integer.parseInt(v);
    }

    default public Map<String, String> commonTags() {
        return Collections.emptyMap();
    }
}

