/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.ipc.http.HttpResponse;
import com.netflix.spectator.stateless.ValidationResponse;
import org.slf4j.Logger;

final class ValidationHelper {
    private final Logger logger;
    private final Counter measurementsSent;
    private final Counter measurementsDroppedInvalid;
    private final Counter measurementsDroppedHttp;
    private final Counter measurementsDroppedOther;

    ValidationHelper(Logger logger, Registry registry) {
        this.logger = logger;
        Id baseId = registry.createId("spectator.measurements");
        Id droppedId = baseId.withTag("id", "dropped");
        this.measurementsSent = registry.counter(baseId.withTag("id", "sent"));
        this.measurementsDroppedHttp = registry.counter(droppedId.withTag("error", "http-error"));
        this.measurementsDroppedInvalid = registry.counter(droppedId.withTag("error", "validation"));
        this.measurementsDroppedOther = registry.counter(droppedId.withTag("error", "other"));
    }

    void incrementDroppedHttp(int amount) {
        this.measurementsDroppedHttp.increment((long)amount);
    }

    void recordResults(int numMeasurements, HttpResponse res) {
        if (res.status() == 200) {
            this.measurementsSent.increment((long)numMeasurements);
        } else if (res.status() < 500) {
            try {
                ValidationResponse vres = ValidationResponse.fromJson(res.entity());
                this.measurementsDroppedInvalid.increment((long)vres.getErrorCount());
                this.measurementsSent.increment((long)(numMeasurements - vres.getErrorCount()));
                this.logger.warn("{} measurement(s) dropped due to validation errors: {}", (Object)vres.getErrorCount(), (Object)vres.errorSummary());
            }
            catch (Exception e) {
                this.logger.trace("failed to parse response", (Throwable)e);
                this.logger.warn("{} measurement(s) dropped. Http status: {}", (Object)numMeasurements, (Object)res.status());
                this.measurementsDroppedOther.increment((long)numMeasurements);
            }
        } else {
            this.measurementsDroppedHttp.increment((long)numMeasurements);
        }
    }
}

