/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

final class ValidationResponse {
    private final String type;
    private final int errorCount;
    private final List<String> message;
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    ValidationResponse(String type, int errorCount, List<String> message) {
        this.type = type;
        this.errorCount = errorCount;
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public List<String> getMessage() {
        return this.message;
    }

    String errorSummary() {
        return this.message == null || this.message.isEmpty() ? "unknown cause" : String.join((CharSequence)"; ", this.message);
    }

    static ValidationResponse fromJson(byte[] json) throws IOException {
        try (JsonParser parser = JSON_FACTORY.createParser(json);){
            String type = null;
            int errorCount = 0;
            ArrayList<String> messages = new ArrayList<String>();
            ValidationResponse.checkToken(parser.nextToken(), EnumSet.of(JsonToken.START_OBJECT));
            block19: while (parser.nextToken() == JsonToken.FIELD_NAME) {
                switch (parser.getText()) {
                    case "type": {
                        type = parser.nextTextValue();
                        continue block19;
                    }
                    case "errorCount": {
                        errorCount = parser.nextIntValue(0);
                        continue block19;
                    }
                    case "message": {
                        JsonToken token = parser.nextToken();
                        ValidationResponse.checkToken(token, EnumSet.of(JsonToken.VALUE_NULL, JsonToken.START_ARRAY));
                        if (token != JsonToken.START_ARRAY) continue block19;
                        while (parser.nextToken() != JsonToken.END_ARRAY) {
                            messages.add(parser.getText());
                        }
                        continue block19;
                    }
                }
                parser.nextToken();
                parser.skipChildren();
            }
            Object object = new ValidationResponse(type, errorCount, messages);
            return object;
        }
    }

    private static void checkToken(JsonToken actual, EnumSet<JsonToken> expected) throws IOException {
        if (!expected.contains(actual)) {
            throw new JsonParseException("expected " + expected + ", but found " + actual);
        }
    }
}

