/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.stateless.StatelessMeter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongToDoubleFunction;

class StatelessTimer
extends StatelessMeter
implements Timer {
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicDouble totalTime = new AtomicDouble(0.0);
    private final AtomicDouble totalOfSquares = new AtomicDouble(0.0);
    private final AtomicDouble max = new AtomicDouble(0.0);
    private final Id[] stats;

    StatelessTimer(Id id, Clock clock, long ttl) {
        super(id, clock, ttl);
        this.stats = new Id[]{id.withTags(new Tag[]{Statistic.count}), id.withTags(new Tag[]{Statistic.totalTime}), id.withTags(new Tag[]{Statistic.totalOfSquares}), id.withTags(new Tag[]{Statistic.max})};
    }

    public void record(long amount, TimeUnit unit) {
        double seconds = (double)unit.toNanos(amount) / 1.0E9;
        if (seconds >= 0.0) {
            this.count.incrementAndGet();
            this.totalTime.addAndGet(seconds);
            this.totalOfSquares.addAndGet(seconds * seconds);
            this.max.max(seconds);
            this.updateLastModTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T record(Callable<T> f) throws Exception {
        long start = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(Runnable f) {
        long start = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public long count() {
        return this.count.get();
    }

    public long totalTime() {
        return (long)(this.totalTime.get() * 1.0E9);
    }

    public Iterable<Measurement> measure() {
        if (this.count.get() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> ms = new ArrayList<Measurement>(4);
        ms.add(this.newMeasurement(this.stats[0], this.count::getAndSet));
        ms.add(this.newMeasurement(this.stats[1], arg_0 -> ((AtomicDouble)this.totalTime).getAndSet(arg_0)));
        ms.add(this.newMeasurement(this.stats[2], arg_0 -> ((AtomicDouble)this.totalOfSquares).getAndSet(arg_0)));
        ms.add(this.newMeasurement(this.stats[3], arg_0 -> ((AtomicDouble)this.max).getAndSet(arg_0)));
        return ms;
    }

    private Measurement newMeasurement(Id mid, LongToDoubleFunction getAndSet) {
        double delta = getAndSet.applyAsDouble(0L);
        long timestamp = this.clock.wallTime();
        return new Measurement(mid, timestamp, delta);
    }
}

