/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.Scheduler;
import com.netflix.spectator.ipc.http.HttpClient;
import com.netflix.spectator.ipc.http.HttpResponse;
import com.netflix.spectator.stateless.JsonUtils;
import com.netflix.spectator.stateless.StatelessConfig;
import com.netflix.spectator.stateless.StatelessCounter;
import com.netflix.spectator.stateless.StatelessDistributionSummary;
import com.netflix.spectator.stateless.StatelessGauge;
import com.netflix.spectator.stateless.StatelessMaxGauge;
import com.netflix.spectator.stateless.StatelessTimer;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class StatelessRegistry
extends AbstractRegistry {
    private final boolean enabled;
    private final Duration frequency;
    private final long meterTTL;
    private final int connectTimeout;
    private final int readTimeout;
    private final URI uri;
    private final int batchSize;
    private final Map<String, String> commonTags;
    private final HttpClient client;
    private Scheduler scheduler;

    public StatelessRegistry(Clock clock, StatelessConfig config) {
        super(clock, (RegistryConfig)config);
        this.enabled = config.enabled();
        this.frequency = config.frequency();
        this.meterTTL = config.meterTTL().toMillis();
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.uri = URI.create(config.uri());
        this.batchSize = config.batchSize();
        this.commonTags = config.commonTags();
        this.client = HttpClient.create((Registry)this);
    }

    public void start() {
        if (this.scheduler == null) {
            if (this.enabled) {
                Scheduler.Options options = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_DELAY, this.frequency).withInitialDelay(this.frequency).withStopOnFailure(false);
                this.scheduler = new Scheduler((Registry)this, "spectator-reg-stateless", 1);
                this.scheduler.schedule(options, this::collectData);
                this.logger.info("started collecting metrics every {} reporting to {}", (Object)this.frequency, (Object)this.uri);
                this.logger.info("common tags: {}", this.commonTags);
            } else {
                this.logger.info("publishing is not enabled");
            }
        } else {
            this.logger.warn("registry already started, ignoring duplicate request");
        }
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
            this.logger.info("flushing metrics before stopping the registry");
            this.collectData();
            this.logger.info("stopped collecting metrics every {} reporting to {}", (Object)this.frequency, (Object)this.uri);
        } else {
            this.logger.warn("registry stopped, but was never started");
        }
    }

    private void collectData() {
        try {
            for (List<Measurement> batch : this.getBatches()) {
                byte[] payload = JsonUtils.encode(this.commonTags, batch);
                HttpResponse res = this.client.post(this.uri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withContent("application/json", payload).compress(1).send();
                if (res.status() == 200) continue;
                this.logger.warn("failed to send metrics, status {}: {}", (Object)res.status(), (Object)res.entityAsString());
            }
            this.removeExpiredMeters();
        }
        catch (Exception e) {
            this.logger.warn("failed to send metrics", (Throwable)e);
        }
    }

    List<Measurement> getMeasurements() {
        return this.stream().filter(m -> !m.hasExpired()).flatMap(m -> StreamSupport.stream(m.measure().spliterator(), false)).collect(Collectors.toList());
    }

    List<List<Measurement>> getBatches() {
        ArrayList<List<Measurement>> batches = new ArrayList<List<Measurement>>();
        List<Measurement> ms = this.getMeasurements();
        for (int i = 0; i < ms.size(); i += this.batchSize) {
            List<Measurement> batch = ms.subList(i, Math.min(ms.size(), i + this.batchSize));
            batches.add(batch);
        }
        return batches;
    }

    protected Counter newCounter(Id id) {
        return new StatelessCounter(id, this.clock(), this.meterTTL);
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        return new StatelessDistributionSummary(id, this.clock(), this.meterTTL);
    }

    protected Timer newTimer(Id id) {
        return new StatelessTimer(id, this.clock(), this.meterTTL);
    }

    protected Gauge newGauge(Id id) {
        return new StatelessGauge(id, this.clock(), this.meterTTL);
    }

    protected Gauge newMaxGauge(Id id) {
        return new StatelessMaxGauge(id, this.clock(), this.meterTTL);
    }
}

