/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.stateless.StatelessMeter;
import java.util.Collections;

class StatelessCounter
extends StatelessMeter
implements Counter {
    private final AtomicDouble count = new AtomicDouble(0.0);
    private final Id stat;

    StatelessCounter(Id id, Clock clock, long ttl) {
        super(id, clock, ttl);
        this.stat = id.withTag((Tag)Statistic.count).withTags(id.tags());
    }

    public Iterable<Measurement> measure() {
        double delta = this.count.getAndSet(0.0);
        if (delta > 0.0) {
            Measurement m = new Measurement(this.stat, this.clock.wallTime(), delta);
            return Collections.singletonList(m);
        }
        return Collections.emptyList();
    }

    public void add(double amount) {
        if (amount > 0.0) {
            this.count.addAndGet(amount);
            this.updateLastModTime();
        }
    }

    public double actualCount() {
        return this.count.get();
    }
}

