/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtils.class);
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final int UNKNOWN = -1;
    private static final int ADD = 0;
    private static final int MAX = 10;

    private JsonUtils() {
    }

    static byte[] encode(Map<String, String> commonTags, List<Measurement> measurements) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator gen = FACTORY.createGenerator((OutputStream)baos);
        gen.writeStartArray();
        Map<String, Integer> strings = JsonUtils.buildStringTable(gen, commonTags, measurements);
        for (Measurement m : measurements) {
            JsonUtils.appendMeasurement(gen, strings, commonTags, m.id(), m.value());
        }
        gen.writeEndArray();
        gen.close();
        return baos.toByteArray();
    }

    private static Map<String, Integer> buildStringTable(JsonGenerator gen, Map<String, String> commonTags, List<Measurement> measurements) throws IOException {
        HashMap<String, Integer> strings = new HashMap<String, Integer>();
        strings.put("name", 0);
        commonTags.forEach((k, v) -> {
            strings.put((String)k, 0);
            strings.put((String)v, 0);
        });
        for (Measurement m : measurements) {
            Id id = m.id();
            strings.put(id.name(), 0);
            for (Tag t : id.tags()) {
                strings.put(t.key(), 0);
                strings.put(t.value(), 0);
            }
        }
        Object[] sorted = strings.keySet().toArray(new String[0]);
        Arrays.sort(sorted);
        gen.writeNumber(sorted.length);
        for (int i = 0; i < sorted.length; ++i) {
            gen.writeString((String)sorted[i]);
            strings.put((String)sorted[i], i);
        }
        return strings;
    }

    private static void appendMeasurement(JsonGenerator gen, Map<String, Integer> strings, Map<String, String> commonTags, Id id, double value) throws IOException {
        int op = JsonUtils.operation(id);
        if (JsonUtils.shouldSend(op, value)) {
            int n = commonTags.size() + 1 + Utils.size((Iterable)id.tags());
            gen.writeNumber(n);
            for (Map.Entry<String, String> entry : commonTags.entrySet()) {
                gen.writeNumber(strings.get(entry.getKey()).intValue());
                gen.writeNumber(strings.get(entry.getValue()).intValue());
            }
            for (Tag t : id.tags()) {
                gen.writeNumber(strings.get(t.key()).intValue());
                gen.writeNumber(strings.get(t.value()).intValue());
            }
            gen.writeNumber(strings.get("name").intValue());
            gen.writeNumber(strings.get(id.name()).intValue());
            gen.writeNumber(op);
            gen.writeNumber(value);
        }
    }

    private static int operation(Id id) {
        for (Tag t : id.tags()) {
            if (!"statistic".equals(t.key())) continue;
            return JsonUtils.operation(t.value());
        }
        LOGGER.warn("invalid statistic for {}, value will be dropped", (Object)id);
        return -1;
    }

    private static int operation(String stat) {
        int op;
        switch (stat) {
            case "count": {
                op = 0;
                break;
            }
            case "totalAmount": {
                op = 0;
                break;
            }
            case "totalTime": {
                op = 0;
                break;
            }
            case "totalOfSquares": {
                op = 0;
                break;
            }
            case "percentile": {
                op = 0;
                break;
            }
            case "max": {
                op = 10;
                break;
            }
            case "gauge": {
                op = 10;
                break;
            }
            case "activeTasks": {
                op = 10;
                break;
            }
            case "duration": {
                op = 10;
                break;
            }
            default: {
                op = -1;
            }
        }
        return op;
    }

    private static boolean shouldSend(int op, double value) {
        return op != -1 && !Double.isNaN(value) && (value > 0.0 || op == 10);
    }
}

