/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.spectator.nflx.tagging.NetflixTagging;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetflixConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetflixConfig.class);

    private NetflixConfig() {
    }

    public static Config createConfig(Config config) {
        try {
            DefaultCompositeConfig cc = new DefaultCompositeConfig(true);
            cc.addConfig("ATLAS", NetflixConfig.loadPropFiles());
            cc.addConfig("ENVIRONMENT", (Config)EnvironmentConfig.INSTANCE);
            cc.addConfig("SYS", (Config)SystemConfig.INSTANCE);
            if (config != null) {
                LOGGER.debug("found injected config, adding as override layer");
                cc.addConfig("INJECTED", config);
            } else {
                LOGGER.debug("no injected config found");
            }
            return cc;
        }
        catch (ConfigException e) {
            throw new IllegalStateException("failed to load atlas config", e);
        }
    }

    static Config loadPropFiles() {
        Properties props = new Properties();
        Env.addDefaults(props);
        String env = Env.environment();
        String acctId = Env.accountId();
        NetflixConfig.tryLoadingConfig(props, "atlas_plugin");
        NetflixConfig.tryLoadingConfig(props, "atlas_plugin-" + env);
        NetflixConfig.tryLoadingConfig(props, "atlas_plugin-acct-" + acctId);
        return MapConfig.from((Properties)props);
    }

    private static void tryLoadingConfig(Properties props, String name) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources(name + ".properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LOGGER.info("loading config file: {}", (Object)url);
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    props.load(in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("failed to load config file: " + name, (Throwable)e);
        }
    }

    private static void put(Map<String, String> map, String key, String maybeNullValue) {
        String value;
        if (maybeNullValue != null && !(value = maybeNullValue.trim()).isEmpty()) {
            map.put(key, maybeNullValue);
        }
    }

    public static Map<String, String> commonTags() {
        return NetflixTagging.commonTagsForAtlas();
    }

    private static class Env {
        private static final String OWNER = "EC2_OWNER_ID";
        private static final String REGION = "EC2_REGION";
        private static final String ENVIRONMENT = "NETFLIX_ENVIRONMENT";
        private static final String APP = "NETFLIX_APP";
        private static final String CLUSTER = "NETFLIX_CLUSTER";

        private Env() {
        }

        private static String getenv(String k, String dflt) {
            String v = System.getenv(k);
            return v == null ? dflt : v;
        }

        private static String environment() {
            return Env.getenv(ENVIRONMENT, "test");
        }

        private static String accountId() {
            return Env.getenv(OWNER, "unknown");
        }

        private static void addDefaults(Properties props) {
            props.put(ENVIRONMENT, "test");
            props.put(OWNER, "unknown");
            props.put(REGION, "us-east-1");
            props.put(APP, "local");
            props.put(CLUSTER, "local-dev");
        }
    }
}

