/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import com.netflix.archaius.api.Config;
import com.netflix.servo.SpectatorContext;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.ExtendedRegistry;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasRegistry;
import com.netflix.spectator.nflx.NetflixConfig;
import com.netflix.spectator.nflx.Plugin;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

public final class SpectatorModule
extends AbstractModule {
    protected void configure() {
        this.bind(Plugin.class).asEagerSingleton();
        this.bind(StaticManager.class).asEagerSingleton();
        this.bind(Config.class).annotatedWith((Annotation)Names.named((String)"spectator")).toProvider(ConfigProvider.class);
        this.bind(AtlasConfig.class).to(AtlasConfiguration.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), ExtendedRegistry.class).setDefault().toInstance((Object)Spectator.registry());
        OptionalBinder.newOptionalBinder((Binder)this.binder(), Clock.class).setDefault().toInstance((Object)Clock.SYSTEM);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), Registry.class).setDefault().to(AtlasRegistry.class).in(Scopes.SINGLETON);
    }

    public boolean equals(Object obj) {
        return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    @Singleton
    private static class AtlasConfiguration
    implements AtlasConfig {
        private final Config cfg;
        private final Map<String, String> nflxCommonTags = NetflixConfig.commonTags();

        @Inject
        AtlasConfiguration(@Named(value="spectator") Config cfg) {
            this.cfg = cfg;
        }

        public String get(String k) {
            String prop = "netflix.spectator.registry." + k;
            return this.cfg.getString(prop, null);
        }

        public boolean enabled() {
            String v = this.get("atlas.enabled");
            return v != null && Boolean.valueOf(v) != false;
        }

        public boolean autoStart() {
            return true;
        }

        public Map<String, String> commonTags() {
            return this.nflxCommonTags;
        }
    }

    private static class StaticManager
    implements AutoCloseable {
        private final Registry registry;

        @Inject
        StaticManager(Registry registry) {
            this.registry = registry;
            Spectator.globalRegistry().add(registry);
            SpectatorContext.setRegistry((Registry)registry);
        }

        @Override
        public void close() {
            Spectator.globalRegistry().remove(this.registry);
            SpectatorContext.setRegistry((Registry)new NoopRegistry());
        }
    }

    @Singleton
    private static class ConfigProvider
    implements Provider<Config> {
        @Inject(optional=true)
        private Config config;
        private Config atlasConfig;

        private ConfigProvider() {
        }

        public Config get() {
            if (this.atlasConfig == null) {
                this.atlasConfig = NetflixConfig.createConfig(this.config);
            }
            return this.atlasConfig;
        }
    }
}

