/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.gc.GcEvent;
import com.netflix.spectator.gc.GcEventListener;
import com.sun.management.GcInfo;
import iep.com.netflix.iep.http.RxHttp;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;
import rx.functions.Action1;

class ChronosGcEventListener
implements GcEventListener {
    private static final DynamicBooleanProperty ENABLED = DynamicPropertyFactory.getInstance().getBooleanProperty("spectator.gc.chronosEnabled", true);
    private static final DynamicStringProperty CHRONOS_URI = DynamicPropertyFactory.getInstance().getStringProperty("spectator.gc.chronosUri", "niws://chronos_gc/api/v2/event");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Registry registry = Spectator.registry();
    private final Id requestCount = this.registry.createId("spectator.gc.chronosPost");
    private final ObjectMapper mapper = new ObjectMapper();
    private final AtomicLong previousEndTime = new AtomicLong(-1L);
    private final RxHttp rxHttp;

    ChronosGcEventListener(RxHttp rxHttp) {
        this.rxHttp = rxHttp;
    }

    private String getenv(String k) {
        String v = System.getenv(k);
        return v == null || v.length() == 0 ? "unknown" : v;
    }

    Map<String, Object> toGcInfoMap(GcEvent event) {
        GcInfo info = event.getInfo().getGcInfo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", info.getId());
        map.put("startTime", event.getStartTime());
        map.put("endTime", event.getStartTime() + info.getDuration());
        map.put("previousEndTime", this.previousEndTime.get());
        map.put("duration", info.getDuration());
        map.put("memoryBeforeGc", info.getMemoryUsageBeforeGc());
        map.put("memoryAfterGc", info.getMemoryUsageAfterGc());
        return map;
    }

    Map<String, Object> toEventMap(GcEvent event) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", event.getInfo().getGcAction());
        map.put("cause", event.getInfo().getGcCause());
        map.put("name", event.getName());
        map.put("gcInfo", this.toGcInfoMap(event));
        map.put("app", this.getenv("NETFLIX_APP"));
        map.put("cluster", this.getenv("NETFLIX_CLUSTER"));
        map.put("asg", this.getenv("NETFLIX_AUTO_SCALE_GROUP"));
        map.put("region", this.getenv("EC2_REGION"));
        map.put("zone", this.getenv("EC2_AVAILABILITY_ZONE"));
        map.put("ami", this.getenv("EC2_AMI_ID"));
        map.put("node", this.getenv("EC2_INSTANCE_ID"));
        return map;
    }

    private void sendToChronos(byte[] json, boolean blocking) {
        URI uri = URI.create(CHRONOS_URI.get());
        final CountDownLatch latch = new CountDownLatch(1);
        final long start = System.nanoTime();
        this.rxHttp.postJson(uri, json).subscribe((Action1)new Action1<HttpClientResponse<ByteBuf>>(){

            public void call(HttpClientResponse<ByteBuf> response) {
                int code = response.getStatus().code();
                if (code != 200) {
                    ChronosGcEventListener.this.logger.warn("failed to send GC event to chronos (status={})", (Object)code);
                }
                long latency = System.nanoTime() - start;
                Id timerId = ChronosGcEventListener.this.requestCount.withTag("status", "" + code);
                ChronosGcEventListener.this.registry.timer(timerId).record(latency, TimeUnit.NANOSECONDS);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable t) {
                ChronosGcEventListener.this.logger.warn("failed to send GC event to chronos", t);
                String status = t.getClass().getSimpleName();
                long latency = System.nanoTime() - start;
                Id timerId = ChronosGcEventListener.this.requestCount.withTag("status", status);
                ChronosGcEventListener.this.registry.timer(timerId).record(latency, TimeUnit.NANOSECONDS);
                latch.countDown();
            }
        }, new Action0(){

            public void call() {
                latch.countDown();
            }
        });
        if (blocking) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    void onComplete(GcEvent event, boolean blocking) {
        if (!ENABLED.get()) {
            return;
        }
        try {
            byte[] json = this.mapper.writeValueAsBytes(this.toEventMap(event));
            this.sendToChronos(json, blocking);
        }
        catch (IOException e) {
            this.logger.warn("failed to send GC event to chronos", (Throwable)e);
        }
        this.previousEndTime.set(event.getStartTime() + event.getInfo().getGcInfo().getDuration());
    }

    public void onComplete(GcEvent event) {
        this.onComplete(event, false);
    }

    public void shutdown() {
    }
}

