/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.config.SystemConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetflixConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetflixConfig.class);

    private NetflixConfig() {
    }

    public static Config createConfig(Config config) {
        try {
            DefaultCompositeConfig cc = new DefaultCompositeConfig(true);
            cc.addConfig("ATLAS", NetflixConfig.loadPropFiles());
            cc.addConfig("ENVIRONMENT", (Config)EnvironmentConfig.INSTANCE);
            cc.addConfig("SYS", (Config)SystemConfig.INSTANCE);
            if (config != null) {
                LOGGER.debug("found injected config, adding as override layer");
                cc.addConfig("INJECTED", config);
            } else {
                LOGGER.debug("no injected config found");
            }
            return cc;
        }
        catch (ConfigException e) {
            throw new IllegalStateException("failed to load atlas config", e);
        }
    }

    static Config loadPropFiles() {
        Properties props = new Properties();
        Env.addDefaults(props);
        String env = Env.environment();
        String acctId = Env.accountId();
        NetflixConfig.tryLoadingConfig(props, "atlas_plugin");
        NetflixConfig.tryLoadingConfig(props, "atlas_plugin-" + env);
        NetflixConfig.tryLoadingConfig(props, "atlas_plugin-acct-" + acctId);
        return MapConfig.from((Properties)props);
    }

    private static void tryLoadingConfig(Properties props, String name) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources(name + ".properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LOGGER.info("loading config file: {}", (Object)url);
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    props.load(in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("failed to load config file: " + name, (Throwable)e);
        }
    }

    private static void put(Map<String, String> map, String key, String maybeNullValue) {
        String value;
        if (maybeNullValue != null && !(value = maybeNullValue.trim()).isEmpty()) {
            map.put(key, maybeNullValue);
        }
    }

    public static Map<String, String> commonTags() {
        HashMap<String, String> commonTags = new HashMap<String, String>();
        NetflixConfig.put(commonTags, "nf.app", Env.app());
        NetflixConfig.put(commonTags, "nf.cluster", Env.cluster());
        NetflixConfig.put(commonTags, "nf.asg", Env.asg());
        NetflixConfig.put(commonTags, "nf.stack", Env.stack());
        NetflixConfig.put(commonTags, "nf.shard1", Env.shard1());
        NetflixConfig.put(commonTags, "nf.shard2", Env.shard2());
        NetflixConfig.put(commonTags, "nf.zone", Env.zone());
        NetflixConfig.put(commonTags, "nf.vmtype", Env.vmtype());
        NetflixConfig.put(commonTags, "nf.node", Env.instanceId());
        NetflixConfig.put(commonTags, "nf.region", Env.region());
        NetflixConfig.put(commonTags, "nf.account", Env.accountId());
        NetflixConfig.put(commonTags, "nf.task", Env.task());
        NetflixConfig.put(commonTags, "nf.job", Env.job());
        return commonTags;
    }

    private static class Env {
        private static final String OWNER = "EC2_OWNER_ID";
        private static final String REGION = "EC2_REGION";
        private static final String ZONE = "EC2_AVAILABILITY_ZONE";
        private static final String INSTANCE_ID = "EC2_INSTANCE_ID";
        private static final String VM_TYPE = "EC2_INSTANCE_TYPE";
        private static final String ENVIRONMENT = "NETFLIX_ENVIRONMENT";
        private static final String APP = "NETFLIX_APP";
        private static final String CLUSTER = "NETFLIX_CLUSTER";
        private static final String ASG = "NETFLIX_AUTO_SCALE_GROUP";
        private static final String STACK = "NETFLIX_STACK";
        private static final String SHARD1 = "NETFLIX_SHARD1";
        private static final String SHARD2 = "NETFLIX_SHARD2";
        private static final String TASK = "TITUS_TASK_ID";
        private static final String JOB = "TITUS_JOB_ID";
        private static final String TITUS_INSTANCE_ID = "TITUS_TASK_INSTANCE_ID";

        private Env() {
        }

        private static String getenv(String k, String dflt) {
            String v = System.getenv(k);
            return v == null ? dflt : v;
        }

        private static String environment() {
            return Env.getenv(ENVIRONMENT, "test");
        }

        private static String accountId() {
            return Env.getenv(OWNER, "unknown");
        }

        private static String region() {
            return System.getenv(REGION);
        }

        private static String zone() {
            return System.getenv(ZONE);
        }

        private static String app() {
            return System.getenv(APP);
        }

        private static String cluster() {
            return System.getenv(CLUSTER);
        }

        private static String asg() {
            return System.getenv(ASG);
        }

        private static String task() {
            return System.getenv(TASK);
        }

        private static String job() {
            return System.getenv(JOB);
        }

        private static String stack() {
            return System.getenv(STACK);
        }

        private static String shard1() {
            return System.getenv(SHARD1);
        }

        private static String shard2() {
            return System.getenv(SHARD2);
        }

        private static String vmtype() {
            return System.getenv(VM_TYPE);
        }

        private static String instanceId() {
            String id = Env.getenv(TITUS_INSTANCE_ID, System.getenv(INSTANCE_ID));
            if (id != null) {
                return id;
            }
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }

        private static void addDefaults(Properties props) {
            props.put(ENVIRONMENT, "test");
            props.put(OWNER, "unknown");
            props.put(REGION, "us-east-1");
            props.put(APP, "local");
            props.put(CLUSTER, "local-dev");
        }
    }
}

