/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.jvm;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spectator-ext-spark.jvm.JmxConfig;
import spectator-ext-spark.jvm.JmxData;
import spectator-ext-spark.jvm.JmxMeasurementConfig;

final class JmxMeter
implements Meter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMeter.class);
    private final Registry registry;
    private final JmxConfig config;
    private final Id id;

    JmxMeter(Registry registry, JmxConfig config) {
        this.registry = registry;
        this.config = config;
        this.id = registry.createId(config.getQuery().getCanonicalName());
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        try {
            for (JmxData data : JmxData.query(this.config.getQuery())) {
                for (JmxMeasurementConfig cfg : this.config.getMeasurements()) {
                    cfg.measure(this.registry, data);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to query jmx data: {}", (Object)this.config.getQuery().getCanonicalName(), (Object)e);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

