/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.jvm;

import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import spectator-ext-spark.com.typesafe.config.Config;
import spectator-ext-spark.jvm.BufferPoolMeter;
import spectator-ext-spark.jvm.HotspotRuntime;
import spectator-ext-spark.jvm.JmxConfig;
import spectator-ext-spark.jvm.JmxMeter;
import spectator-ext-spark.jvm.MemoryPoolMeter;

public final class Jmx {
    private Jmx() {
    }

    public static void registerStandardMXBeans(Registry registry) {
        Jmx.monitorClassLoadingMXBean(registry);
        Jmx.monitorThreadMXBean(registry);
        Jmx.monitorCompilationMXBean(registry);
        Jmx.maybeRegisterHotspotInternal(registry);
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            registry.register(new MemoryPoolMeter(registry, memoryPoolMXBean));
        }
        for (BufferPoolMXBean bufferPoolMXBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            registry.register(new BufferPoolMeter(registry, bufferPoolMXBean));
        }
    }

    private static void monitorClassLoadingMXBean(Registry registry) {
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        PolledMeter.using(registry).withName("jvm.classloading.classesLoaded").monitorMonotonicCounter(classLoadingMXBean, ClassLoadingMXBean::getTotalLoadedClassCount);
        PolledMeter.using(registry).withName("jvm.classloading.classesUnloaded").monitorMonotonicCounter(classLoadingMXBean, ClassLoadingMXBean::getUnloadedClassCount);
    }

    private static void monitorThreadMXBean(Registry registry) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        PolledMeter.using(registry).withName("jvm.thread.threadsStarted").monitorMonotonicCounter(threadMXBean, ThreadMXBean::getTotalStartedThreadCount);
        Gauge nonDaemonThreadCount = registry.gauge("jvm.thread.threadCount", "id", "non-daemon");
        Gauge daemonThreadCount = registry.gauge("jvm.thread.threadCount", "id", "daemon");
        PolledMeter.poll(registry, () -> {
            int threads = threadMXBean.getThreadCount();
            int daemonThreads = threadMXBean.getDaemonThreadCount();
            nonDaemonThreadCount.set(Math.max(0, threads - daemonThreads));
            daemonThreadCount.set(daemonThreads);
        });
    }

    private static void monitorCompilationMXBean(Registry registry) {
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean.isCompilationTimeMonitoringSupported()) {
            ((PolledMeter.Builder)PolledMeter.using(registry).withName("jvm.compilation.compilationTime").withTag("compiler", compilationMXBean.getName())).monitorMonotonicCounterDouble(compilationMXBean, c -> (double)c.getTotalCompilationTime() / 1000.0);
        }
    }

    private static void maybeRegisterHotspotInternal(Registry registry) {
        if (HotspotRuntime.isSupported()) {
            Object mbean = HotspotRuntime.getRuntimeMBean();
            ((PolledMeter.Builder)PolledMeter.using(registry).withName("jvm.hotspot.safepointTime").withTag(Statistic.count)).monitorMonotonicCounter(mbean, b -> HotspotRuntime.getSafepointCount());
            ((PolledMeter.Builder)PolledMeter.using(registry).withName("jvm.hotspot.safepointTime").withTag(Statistic.totalTime)).monitorMonotonicCounterDouble(mbean, b -> (double)HotspotRuntime.getSafepointTime() / 1000.0);
            ((PolledMeter.Builder)PolledMeter.using(registry).withName("jvm.hotspot.safepointSyncTime").withTag(Statistic.count)).monitorMonotonicCounter(mbean, b -> HotspotRuntime.getSafepointCount());
            ((PolledMeter.Builder)PolledMeter.using(registry).withName("jvm.hotspot.safepointSyncTime").withTag(Statistic.totalTime)).monitorMonotonicCounterDouble(mbean, b -> (double)HotspotRuntime.getSafepointSyncTime() / 1000.0);
        }
    }

    public static void registerMappingsFromConfig(Registry registry, Config cfg) {
        registry.register(new JmxMeter(registry, JmxConfig.from(cfg)));
    }
}

