/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.impl.matcher;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import spectator-ext-spark.impl.matcher.EndMatcher;
import spectator-ext-spark.impl.matcher.GreedyMatcher;
import spectator-ext-spark.impl.matcher.Matcher;
import spectator-ext-spark.impl.matcher.PatternUtils;
import spectator-ext-spark.impl.matcher.SeqMatcher;
import spectator-ext-spark.impl.matcher.TrueMatcher;

final class IndexOfMatcher
implements GreedyMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String pattern;
    private final Matcher next;
    private final boolean ignoreCase;

    IndexOfMatcher(String pattern, Matcher next) {
        this(pattern, next, false);
    }

    IndexOfMatcher(String pattern, Matcher next, boolean ignoreCase) {
        this.pattern = pattern;
        this.next = next;
        this.ignoreCase = ignoreCase;
    }

    String pattern() {
        return this.pattern;
    }

    Matcher next() {
        return this.next;
    }

    @Override
    public String containedString() {
        return this.pattern;
    }

    @Override
    public boolean isContainsMatcher() {
        return this.next == TrueMatcher.INSTANCE;
    }

    private int indexOfIgnoreCase(String str, int offset) {
        int length = this.pattern.length();
        int end = str.length() - length + 1;
        for (int i = offset; i < end; ++i) {
            if (!str.regionMatches(true, i, this.pattern, 0, length)) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(String str, int offset) {
        return this.ignoreCase ? this.indexOfIgnoreCase(str, offset) : str.indexOf(this.pattern, offset);
    }

    private boolean endsWithIgnoreCase(String str) {
        int length = this.pattern.length();
        int offset = str.length() - length;
        return str.regionMatches(true, offset, this.pattern, 0, length);
    }

    private boolean endsWith(String str, int offset) {
        int length;
        int remaining = str.length() - offset;
        if (remaining < (length = this.pattern.length())) {
            return false;
        }
        return this.ignoreCase ? this.endsWithIgnoreCase(str) : str.endsWith(this.pattern);
    }

    @Override
    public int matches(String str, int start, int length) {
        if (this.next == TrueMatcher.INSTANCE) {
            int pos = this.indexOf(str, start);
            return pos >= 0 ? pos + this.pattern.length() : -1;
        }
        if (this.next == EndMatcher.INSTANCE) {
            return this.endsWith(str, start) ? length : -1;
        }
        int end = start + length;
        int stop = end - this.next.minLength();
        int pos = start;
        while (pos >= 0 && pos <= stop) {
            if ((pos = this.indexOf(str, pos)) < 0) continue;
            int s = pos + this.pattern.length();
            int p = this.next.matches(str, s, end - s);
            if (p >= 0) {
                return p;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public int minLength() {
        return this.pattern.length() + this.next.minLength();
    }

    @Override
    public boolean isEndAnchored() {
        return this.next.isEndAnchored();
    }

    @Override
    public Matcher mergeNext(Matcher after) {
        if (after instanceof TrueMatcher) {
            return this;
        }
        Matcher m = this.next instanceof TrueMatcher ? after : SeqMatcher.create(this.next, after);
        return new IndexOfMatcher(this.pattern, m);
    }

    @Override
    public Matcher rewrite(Function<Matcher, Matcher> f) {
        return f.apply(new IndexOfMatcher(this.pattern, this.next.rewrite(f)));
    }

    @Override
    public Matcher rewriteEnd(Function<Matcher, Matcher> f) {
        return f.apply(new IndexOfMatcher(this.pattern, this.next.rewriteEnd(f)));
    }

    public String toString() {
        return ".*" + PatternUtils.escape(this.pattern) + this.next;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexOfMatcher that = (IndexOfMatcher)o;
        return this.ignoreCase == that.ignoreCase && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + this.next.hashCode();
        result = 31 * result + Boolean.hashCode(this.ignoreCase);
        return result;
    }
}

