/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.gc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

class CircularBuffer<T> {
    private final AtomicInteger nextIndex = new AtomicInteger(0);
    private final AtomicReferenceArray<T> data;

    CircularBuffer(int length) {
        this.data = new AtomicReferenceArray(length);
    }

    void add(T item) {
        int i = this.nextIndex.getAndIncrement() % this.data.length();
        this.data.set(i, item);
    }

    T get(int i) {
        return this.data.get(i);
    }

    int size() {
        return this.data.length();
    }

    List<T> toList() {
        ArrayList<T> items = new ArrayList<T>(this.data.length());
        for (int i = 0; i < this.data.length(); ++i) {
            T item = this.data.get(i);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }
}

