/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import java.util.HashMap;
import java.util.Map;
import spectator-ext-spark.com.typesafe.config.Config;
import spectator-ext-spark.sidecar.SidecarConfig;

class SpectatorConfig
implements SidecarConfig {
    private final Config config;

    SpectatorConfig(Config config) {
        this.config = config;
    }

    @Override
    public String get(String k) {
        return this.config.hasPath(k) ? this.config.getString(k) : null;
    }

    @Override
    public String outputLocation() {
        return this.config.getString("output-location");
    }

    @Override
    public Map<String, String> commonTags() {
        HashMap<String, String> tags = new HashMap<String, String>(SidecarConfig.super.commonTags());
        for (Config config : this.config.getConfigList("tags")) {
            String value = config.getString("value");
            if (value.isEmpty()) continue;
            tags.put(config.getString("key"), config.getString("value"));
        }
        return tags;
    }
}

