/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.sidecar;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.StandardCharsets;
import spectator-ext-spark.sidecar.SidecarWriter;

final class UdpWriter
extends SidecarWriter {
    private final DatagramChannel channel = DatagramChannel.open();

    UdpWriter(String location, SocketAddress address) throws IOException {
        super(location);
        this.channel.connect(address);
    }

    @Override
    public void writeImpl(String line) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8));
        this.channel.write(buffer);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

