/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.sidecar;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spectator-ext-spark.sidecar.NoopWriter;
import spectator-ext-spark.sidecar.PrintStreamWriter;
import spectator-ext-spark.sidecar.UdpWriter;

abstract class SidecarWriter
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarWriter.class);
    private final String location;
    private volatile boolean suppressWarnings;

    static SidecarWriter create(String location) {
        try {
            if ("none".equals(location)) {
                return new NoopWriter();
            }
            if ("stderr".equals(location)) {
                return new PrintStreamWriter(location, System.err);
            }
            if ("stdout".equals(location)) {
                return new PrintStreamWriter(location, System.out);
            }
            if (location.startsWith("file://")) {
                OutputStream out = Files.newOutputStream(Paths.get(URI.create(location)), new OpenOption[0]);
                PrintStream stream = new PrintStream(out, false, "UTF-8");
                return new PrintStreamWriter(location, stream);
            }
            if (location.startsWith("udp://")) {
                URI uri = URI.create(location);
                String host = uri.getHost();
                int port = uri.getPort();
                InetSocketAddress address = new InetSocketAddress(host, port);
                return new UdpWriter(location, address);
            }
            throw new IllegalArgumentException("unsupported location: " + location);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    SidecarWriter(String location) {
        this.location = location;
        this.suppressWarnings = false;
    }

    abstract void writeImpl(String var1) throws IOException;

    void write(String line) {
        block2: {
            try {
                LOGGER.trace("writing to {}: {}", (Object)this.location, (Object)line);
                this.writeImpl(line);
            }
            catch (IOException e) {
                if (this.suppressWarnings) break block2;
                LOGGER.warn("write to {} failed: {}", new Object[]{this.location, line, e});
                this.suppressWarnings = true;
            }
        }
    }

    void write(String prefix, long value) {
        this.write(prefix + value);
    }

    void write(String prefix, double value) {
        this.write(prefix + value);
    }
}

