/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.sidecar;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import spectator-ext-spark.sidecar.SidecarMeter;
import spectator-ext-spark.sidecar.SidecarWriter;

class SidecarTimer
extends SidecarMeter
implements Timer {
    private final Clock clock;
    private final SidecarWriter writer;

    SidecarTimer(Id id, Clock clock, SidecarWriter writer) {
        super(id, 't');
        this.clock = clock;
        this.writer = writer;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        double seconds = (double)unit.toNanos(amount) / 1.0E9;
        if (seconds >= 0.0) {
            this.writer.write(this.idString, seconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> f) throws Exception {
        long start = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long start = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public long totalTime() {
        return 0L;
    }
}

