/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.sidecar;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import spectator-ext-spark.sidecar.SidecarConfig;
import spectator-ext-spark.sidecar.SidecarCounter;
import spectator-ext-spark.sidecar.SidecarDistributionSummary;
import spectator-ext-spark.sidecar.SidecarGauge;
import spectator-ext-spark.sidecar.SidecarMaxGauge;
import spectator-ext-spark.sidecar.SidecarTimer;
import spectator-ext-spark.sidecar.SidecarWriter;

public final class SidecarRegistry
implements Registry,
Closeable {
    private final Clock clock;
    private final TagList commonTags;
    private final SidecarWriter writer;
    private final ConcurrentHashMap<Id, Object> state;

    public SidecarRegistry(Clock clock, SidecarConfig config) {
        this(clock, config, SidecarWriter.create(config.outputLocation()));
    }

    SidecarRegistry(Clock clock, SidecarConfig config, SidecarWriter writer) {
        this.clock = clock;
        this.commonTags = TagList.create(config.commonTags());
        this.writer = writer;
        this.state = new ConcurrentHashMap();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.state.clear();
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Id createId(String name) {
        return Id.create(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return Id.create(name).withTags(tags);
    }

    @Override
    @Deprecated
    public void register(Meter meter) {
        PolledMeter.monitorMeter(this, meter);
    }

    @Override
    public ConcurrentMap<Id, Object> state() {
        return this.state;
    }

    private Id mergeCommonTags(Id id) {
        return this.commonTags.size() == 0 ? id : id.withTags(this.commonTags);
    }

    @Override
    public Counter counter(Id id) {
        return new SidecarCounter(this.mergeCommonTags(id), this.writer);
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return new SidecarDistributionSummary(this.mergeCommonTags(id), this.writer);
    }

    @Override
    public Timer timer(Id id) {
        return new SidecarTimer(this.mergeCommonTags(id), this.clock, this.writer);
    }

    @Override
    public Gauge gauge(Id id) {
        return new SidecarGauge(this.mergeCommonTags(id), this.writer);
    }

    @Override
    public Gauge maxGauge(Id id) {
        return new SidecarMaxGauge(this.mergeCommonTags(id), this.writer);
    }

    @Override
    public Meter get(Id id) {
        return null;
    }

    @Override
    public Iterator<Meter> iterator() {
        return Collections.emptyIterator();
    }
}

