/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.sidecar;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import java.util.Collections;
import spectator-ext-spark.impl.AsciiSet;

abstract class SidecarMeter
implements Meter {
    private static final AsciiSet ALLOWED_CHARS = AsciiSet.fromPattern("-._A-Za-z0-9~^");
    protected final Id id;
    protected final String idString;

    SidecarMeter(Id id, char type) {
        this.id = id;
        this.idString = this.createIdString(id, type);
    }

    private String replaceInvalidChars(String s) {
        return ALLOWED_CHARS.replaceNonMembers(s, '_');
    }

    private String createIdString(Id id, char type) {
        StringBuilder builder = new StringBuilder();
        builder.append(type).append(':').append(this.replaceInvalidChars(id.name()));
        int n = id.size();
        for (int i = 1; i < n; ++i) {
            String k = this.replaceInvalidChars(id.getKey(i));
            String v = this.replaceInvalidChars(id.getValue(i));
            builder.append(',').append(k).append('=').append(v);
        }
        return builder.append(':').toString();
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }
}

