/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.impl.matcher;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import spectator-ext-spark.impl.matcher.AnyMatcher;
import spectator-ext-spark.impl.matcher.CharClassMatcher;
import spectator-ext-spark.impl.matcher.CharSeqMatcher;
import spectator-ext-spark.impl.matcher.EndMatcher;
import spectator-ext-spark.impl.matcher.FalseMatcher;
import spectator-ext-spark.impl.matcher.GreedyMatcher;
import spectator-ext-spark.impl.matcher.IndexOfMatcher;
import spectator-ext-spark.impl.matcher.Matcher;
import spectator-ext-spark.impl.matcher.OrMatcher;
import spectator-ext-spark.impl.matcher.PatternUtils;
import spectator-ext-spark.impl.matcher.SeqMatcher;
import spectator-ext-spark.impl.matcher.StartMatcher;
import spectator-ext-spark.impl.matcher.StartsWithMatcher;
import spectator-ext-spark.impl.matcher.TrueMatcher;
import spectator-ext-spark.impl.matcher.ZeroOrMoreMatcher;
import spectator-ext-spark.impl.matcher.ZeroOrOneMatcher;

final class Optimizer {
    private static final int MAX_ITERATIONS = 1000;

    private Optimizer() {
    }

    static Matcher optimize(Matcher matcher) {
        Matcher m = matcher;
        Matcher opt = Optimizer.optimizeSinglePass(m);
        for (int i = 0; !m.equals(opt) && i < 1000; ++i) {
            m = opt;
            opt = Optimizer.optimizeSinglePass(m);
        }
        return opt;
    }

    private static Matcher optimizeSinglePass(Matcher matcher) {
        return matcher.rewrite(Optimizer::mergeNext).rewrite(Optimizer::removeTrueInSequence).rewrite(Optimizer::sequenceWithFalseIsFalse).rewrite(Optimizer::sequenceWithStuffAfterEndIsFalse).rewrite(Optimizer::zeroOrMoreFalse).rewrite(Optimizer::convertEmptyCharClassToFalse).rewrite(Optimizer::convertSingleCharClassToSeq).rewrite(Optimizer::removeStartFollowedByMatchAny).rewrite(Optimizer::removeMatchAnyFollowedByStart).rewrite(Optimizer::removeMatchAnyFollowedByIndexOf).rewrite(Optimizer::removeSequentialMatchAny).rewrite(Optimizer::flattenNestedSequences).rewrite(Optimizer::flattenNestedOr).rewrite(Optimizer::dedupOr).rewrite(Optimizer::removeFalseBranchesFromOr).rewrite(Optimizer::extractPrefixFromOr).rewrite(Optimizer::inlineMatchAnyPrecedingOr).rewrite(Optimizer::startsWithCharSeq).rewrite(Optimizer::combineCharSeqAfterStartsWith).rewrite(Optimizer::combineCharSeqAfterIndexOf).rewrite(Optimizer::combineAdjacentCharSeqs).rewrite(Optimizer::removeRepeatedStart).rewrite(Optimizer::combineAdjacentStart).rewrite(Optimizer::convertRepeatedAnyCharSeqToIndexOf).rewriteEnd(Optimizer::removeTrailingMatchAny);
    }

    static Matcher mergeNext(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> matchers = ((SeqMatcher)matcher.as()).matchers();
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            for (int i = 0; i < matchers.size(); ++i) {
                Matcher m = matchers.get(i);
                if (m instanceof OrMatcher) {
                    if (i + 1 < matchers.size() && matchers.get(i + 1) instanceof OrMatcher) {
                        ms.add(m);
                        continue;
                    }
                    List<Matcher> after = matchers.subList(i + 1, matchers.size());
                    ms.add(((GreedyMatcher)m.as()).mergeNext(SeqMatcher.create(after)));
                    break;
                }
                if (m instanceof GreedyMatcher) {
                    List<Matcher> after = matchers.subList(i + 1, matchers.size());
                    ms.add(((GreedyMatcher)m.as()).mergeNext(SeqMatcher.create(after)));
                    break;
                }
                ms.add(m);
            }
            return SeqMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher removeTrueInSequence(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> matchers = ((SeqMatcher)matcher.as()).matchers();
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            for (Matcher m : matchers) {
                if (m instanceof TrueMatcher) continue;
                ms.add(m);
            }
            return SeqMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher sequenceWithFalseIsFalse(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            for (Matcher m : ((SeqMatcher)matcher.as()).matchers()) {
                if (!(m instanceof FalseMatcher)) continue;
                return FalseMatcher.INSTANCE;
            }
        }
        return matcher;
    }

    static Matcher sequenceWithStuffAfterEndIsFalse(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            boolean end = false;
            for (Matcher m : ((SeqMatcher)matcher.as()).matchers()) {
                if (m instanceof EndMatcher) {
                    end = true;
                    continue;
                }
                if (!end || m.alwaysMatches()) continue;
                return FalseMatcher.INSTANCE;
            }
        }
        return matcher;
    }

    static Matcher zeroOrMoreFalse(Matcher matcher) {
        ZeroOrOneMatcher zm;
        if (matcher instanceof ZeroOrMoreMatcher) {
            ZeroOrMoreMatcher zm2 = (ZeroOrMoreMatcher)matcher.as();
            if (zm2.repeated() instanceof FalseMatcher || zm2.next() instanceof FalseMatcher) {
                return zm2.next();
            }
        } else if (matcher instanceof ZeroOrOneMatcher && ((zm = (ZeroOrOneMatcher)matcher.as()).repeated() instanceof FalseMatcher || zm.next() instanceof FalseMatcher)) {
            return zm.next();
        }
        return matcher;
    }

    static Matcher convertEmptyCharClassToFalse(Matcher matcher) {
        if (matcher instanceof CharClassMatcher) {
            return ((CharClassMatcher)matcher.as()).set().isEmpty() ? FalseMatcher.INSTANCE : matcher;
        }
        return matcher;
    }

    static Matcher convertSingleCharClassToSeq(Matcher matcher) {
        Optional<Character> opt;
        if (matcher instanceof CharClassMatcher && (opt = ((CharClassMatcher)matcher.as()).set().character()).isPresent()) {
            return new CharSeqMatcher(opt.get().charValue());
        }
        return matcher;
    }

    static Matcher removeStartFollowedByMatchAny(Matcher matcher) {
        ZeroOrMoreMatcher zm;
        List<Matcher> matchers;
        if (matcher instanceof SeqMatcher && (matchers = ((SeqMatcher)matcher.as()).matchers()).size() == 2 && matchers.get(0) instanceof StartMatcher && matchers.get(1) instanceof ZeroOrMoreMatcher && (zm = (ZeroOrMoreMatcher)matchers.get(1).as()).repeated() instanceof AnyMatcher) {
            return zm;
        }
        return matcher;
    }

    static Matcher removeMatchAnyFollowedByStart(Matcher matcher) {
        ZeroOrMoreMatcher zm;
        if (matcher instanceof ZeroOrMoreMatcher && (zm = (ZeroOrMoreMatcher)matcher.as()).repeated() instanceof AnyMatcher && zm.next() instanceof SeqMatcher && ((SeqMatcher)zm.next().as()).matchers().get(0).isStartAnchored()) {
            return zm.next();
        }
        return matcher;
    }

    static Matcher removeMatchAnyFollowedByIndexOf(Matcher matcher) {
        ZeroOrMoreMatcher zm;
        if (matcher instanceof ZeroOrMoreMatcher && (zm = (ZeroOrMoreMatcher)matcher.as()).repeated() instanceof AnyMatcher && PatternUtils.getPrefix(zm.next()) instanceof IndexOfMatcher) {
            return zm.next();
        }
        return matcher;
    }

    static Matcher removeTrailingMatchAny(Matcher matcher) {
        if (matcher instanceof ZeroOrMoreMatcher) {
            boolean atEnd;
            ZeroOrMoreMatcher zm = (ZeroOrMoreMatcher)matcher.as();
            boolean bl = atEnd = zm.next() instanceof TrueMatcher || zm.next() instanceof EndMatcher;
            if (atEnd && zm.repeated() instanceof AnyMatcher) {
                return TrueMatcher.INSTANCE;
            }
        }
        return matcher;
    }

    static Matcher removeSequentialMatchAny(Matcher matcher) {
        ZeroOrMoreMatcher zm2;
        ZeroOrMoreMatcher zm1;
        if (matcher instanceof ZeroOrMoreMatcher && (zm1 = (ZeroOrMoreMatcher)matcher.as()).repeated() instanceof AnyMatcher && zm1.next() instanceof ZeroOrMoreMatcher && (zm2 = (ZeroOrMoreMatcher)zm1.next().as()).repeated() instanceof AnyMatcher) {
            return zm2;
        }
        return matcher;
    }

    static Matcher flattenNestedSequences(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> matchers = ((SeqMatcher)matcher.as()).matchers();
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            for (Matcher m : matchers) {
                if (m instanceof SeqMatcher) {
                    ms.addAll(((SeqMatcher)m.as()).matchers());
                    continue;
                }
                ms.add(m);
            }
            return SeqMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher flattenNestedOr(Matcher matcher) {
        if (matcher instanceof OrMatcher) {
            List<Matcher> matchers = ((OrMatcher)matcher.as()).matchers();
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            for (Matcher m : matchers) {
                if (m instanceof OrMatcher) {
                    ms.addAll(((OrMatcher)m.as()).matchers());
                    continue;
                }
                ms.add(m);
            }
            return OrMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher dedupOr(Matcher matcher) {
        if (matcher instanceof OrMatcher) {
            ArrayList<Matcher> ms = new ArrayList<Matcher>(new LinkedHashSet<Matcher>(((OrMatcher)matcher.as()).matchers()));
            return OrMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher removeFalseBranchesFromOr(Matcher matcher) {
        if (matcher instanceof OrMatcher) {
            List<Matcher> ms = ((OrMatcher)matcher.as()).matchers().stream().filter(m -> !(m instanceof FalseMatcher)).collect(Collectors.toList());
            return OrMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher extractPrefixFromOr(Matcher matcher) {
        if (matcher instanceof OrMatcher) {
            List<Matcher> matchers = ((OrMatcher)matcher.as()).matchers();
            if (matchers.isEmpty()) {
                return matcher;
            }
            Matcher prefix = PatternUtils.getPrefix(matchers.get(0));
            if (prefix.alwaysMatches()) {
                return matcher;
            }
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            ms.add(PatternUtils.getSuffix(matchers.get(0)));
            for (Matcher m : matchers.subList(1, matchers.size())) {
                Matcher p = PatternUtils.getPrefix(m);
                if (!prefix.equals(p)) {
                    return matcher;
                }
                ms.add(PatternUtils.getSuffix(m));
            }
            return SeqMatcher.create(prefix, OrMatcher.create(ms));
        }
        return matcher;
    }

    static Matcher inlineMatchAnyPrecedingOr(Matcher matcher) {
        ZeroOrMoreMatcher zm;
        if (matcher instanceof ZeroOrMoreMatcher && (zm = (ZeroOrMoreMatcher)matcher.as()).repeated() instanceof AnyMatcher && zm.next() instanceof OrMatcher) {
            List<Matcher> matchers = ((OrMatcher)zm.next().as()).matchers();
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            for (Matcher m : matchers) {
                ms.add(new ZeroOrMoreMatcher(AnyMatcher.INSTANCE, m));
            }
            return OrMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher startsWithCharSeq(Matcher matcher) {
        List<Matcher> matchers;
        if (matcher instanceof SeqMatcher && (matchers = ((SeqMatcher)matcher.as()).matchers()).size() >= 2 && matchers.get(0) instanceof StartMatcher && matchers.get(1) instanceof CharSeqMatcher) {
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            ms.add(new StartsWithMatcher(((CharSeqMatcher)matchers.get(1).as()).pattern()));
            ms.addAll(matchers.subList(2, matchers.size()));
            return SeqMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher combineCharSeqAfterStartsWith(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> matchers = ((SeqMatcher)matcher.as()).matchers();
            if (matchers.size() >= 2 && matchers.get(0) instanceof StartsWithMatcher && matchers.get(1) instanceof CharSeqMatcher) {
                ArrayList<Matcher> ms = new ArrayList<Matcher>();
                String prefix = ((StartsWithMatcher)matchers.get(0).as()).pattern() + ((CharSeqMatcher)matchers.get(1).as()).pattern();
                ms.add(new StartsWithMatcher(prefix));
                ms.addAll(matchers.subList(2, matchers.size()));
                return SeqMatcher.create(ms);
            }
            return matcher;
        }
        return matcher;
    }

    static Matcher combineCharSeqAfterIndexOf(Matcher matcher) {
        IndexOfMatcher m;
        Matcher next;
        if (matcher instanceof IndexOfMatcher && (next = PatternUtils.head((m = (IndexOfMatcher)matcher.as()).next())) instanceof CharSeqMatcher) {
            String pattern = m.pattern() + ((CharSeqMatcher)next.as()).pattern();
            return new IndexOfMatcher(pattern, PatternUtils.tail(m.next()));
        }
        return matcher;
    }

    static Matcher combineAdjacentCharSeqs(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> matchers = ((SeqMatcher)matcher.as()).matchers();
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            CharSeqMatcher cs1 = null;
            for (Matcher m : matchers) {
                if (m instanceof CharSeqMatcher) {
                    if (cs1 == null) {
                        cs1 = (CharSeqMatcher)m.as();
                        continue;
                    }
                    CharSeqMatcher cs2 = (CharSeqMatcher)m.as();
                    cs1 = new CharSeqMatcher(cs1.pattern() + cs2.pattern());
                    continue;
                }
                if (cs1 != null) {
                    ms.add(cs1);
                    cs1 = null;
                }
                ms.add(m);
            }
            if (cs1 != null) {
                ms.add(cs1);
            }
            return SeqMatcher.create(ms);
        }
        return matcher;
    }

    static Matcher convertRepeatedAnyCharSeqToIndexOf(Matcher matcher) {
        if (matcher instanceof ZeroOrMoreMatcher) {
            ZeroOrMoreMatcher zm1 = (ZeroOrMoreMatcher)matcher.as();
            Matcher prefix = PatternUtils.getPrefix(zm1.next());
            if (zm1.repeated() instanceof AnyMatcher && prefix instanceof CharSeqMatcher) {
                String pattern = ((CharSeqMatcher)prefix.as()).pattern();
                Matcher suffix = PatternUtils.getSuffix(zm1.next());
                return new IndexOfMatcher(pattern, suffix);
            }
        }
        return matcher;
    }

    static Matcher removeRepeatedStart(Matcher matcher) {
        ZeroOrMoreMatcher zm;
        if (matcher instanceof ZeroOrMoreMatcher && (zm = (ZeroOrMoreMatcher)matcher.as()).repeated() instanceof StartMatcher) {
            return zm.next();
        }
        return matcher;
    }

    static Matcher combineAdjacentStart(Matcher matcher) {
        List<Matcher> matchers;
        if (matcher instanceof SeqMatcher && !(matchers = ((SeqMatcher)matcher.as()).matchers()).isEmpty() && matchers.get(0) instanceof StartMatcher) {
            ArrayList<Matcher> ms = new ArrayList<Matcher>();
            ms.add(StartMatcher.INSTANCE);
            int pos = 0;
            for (Matcher m : matchers) {
                if (!(m instanceof StartMatcher)) break;
                ++pos;
            }
            ms.addAll(matchers.subList(pos, matchers.size()));
            return SeqMatcher.create(ms);
        }
        return matcher;
    }
}

