/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.impl;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class UnsafeUtils {
    private static final Unsafe UNSAFE;
    private static final long STRING_VALUE_OFFSET;
    private static final boolean STRING_VALUE_BYTES;

    private UnsafeUtils() {
    }

    public static boolean supported() {
        return UNSAFE != null;
    }

    public static boolean stringValueSupported() {
        return STRING_VALUE_OFFSET > 0L;
    }

    public static boolean stringValueBytes() {
        return STRING_VALUE_BYTES;
    }

    public static byte[] getStringValueBytes(String str) {
        return (byte[])UNSAFE.getObject(str, STRING_VALUE_OFFSET);
    }

    public static char[] getStringValueChars(String str) {
        return (char[])UNSAFE.getObject(str, STRING_VALUE_OFFSET);
    }

    public static long getLong(byte[] bytes, int offset) {
        long idx = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        return UNSAFE.getLong(bytes, idx);
    }

    static {
        Unsafe instance;
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            instance = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            instance = null;
        }
        UNSAFE = instance;
        if (UNSAFE != null) {
            boolean stringValueBytes;
            long stringValueOffset;
            try {
                Field value = String.class.getDeclaredField("value");
                stringValueOffset = UNSAFE.objectFieldOffset(value);
                Object obj = UNSAFE.getObject("value", stringValueOffset);
                stringValueBytes = obj instanceof byte[];
            }
            catch (Exception e) {
                stringValueOffset = -1L;
                stringValueBytes = false;
            }
            STRING_VALUE_OFFSET = stringValueOffset;
            STRING_VALUE_BYTES = stringValueBytes;
        } else {
            STRING_VALUE_OFFSET = -1L;
            STRING_VALUE_BYTES = false;
        }
    }
}

