/*
 * Decompiled with CFR 0.152.
 */
package spectator-ext-spark.impl;

import spectator-ext-spark.impl.UnsafeUtils;

public final class Hash64 {
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -4417276706812531889L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;
    private final long[] stripe;
    private int stripePos;
    private int bitPos;
    private final long seed;
    private long acc1;
    private long acc2;
    private long acc3;
    private long acc4;
    private long inputLength;

    public Hash64() {
        this(0L);
    }

    public Hash64(long seed) {
        this.seed = seed;
        this.stripe = new long[4];
        this.reset();
    }

    public void reset() {
        this.stripePos = 0;
        this.bitPos = 0;
        this.stripe[0] = 0L;
        this.acc1 = this.seed + -7046029288634856825L + -4417276706812531889L;
        this.acc2 = this.seed + -4417276706812531889L;
        this.acc3 = this.seed;
        this.acc4 = this.seed - -7046029288634856825L;
        this.inputLength = 0L;
    }

    private void checkSpace(int size) {
        if (size > 64 - this.bitPos) {
            if (++this.stripePos == this.stripe.length) {
                this.processStripe();
            }
            this.bitPos = 0;
            this.stripe[this.stripePos] = 0L;
        }
    }

    public Hash64 updateBoolean(boolean value) {
        return this.updateByte((byte)(value ? 1 : 0));
    }

    public Hash64 updateBooleans(boolean[] values, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.updateBoolean(values[i]);
        }
        return this;
    }

    public Hash64 updateBooleans(boolean[] values) {
        return this.updateBooleans(values, 0, values.length);
    }

    public Hash64 updateChar(char value) {
        this.checkSpace(16);
        long c = (long)value << this.bitPos;
        int n = this.stripePos;
        this.stripe[n] = this.stripe[n] | c;
        this.bitPos += 16;
        return this;
    }

    public Hash64 updateChars(char[] values, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.updateChar(values[i]);
        }
        return this;
    }

    public Hash64 updateChars(char[] values) {
        return this.updateChars(values, 0, values.length);
    }

    public Hash64 updateString(CharSequence str) {
        if (str instanceof String && UnsafeUtils.stringValueSupported()) {
            if (UnsafeUtils.stringValueBytes()) {
                byte[] vs = UnsafeUtils.getStringValueBytes((String)str);
                this.updateBytes(vs, 0, vs.length);
            } else {
                char[] vs = UnsafeUtils.getStringValueChars((String)str);
                this.updateChars(vs, 0, vs.length);
            }
        } else {
            for (int i = 0; i < str.length(); ++i) {
                this.updateChar(str.charAt(i));
            }
        }
        return this;
    }

    public Hash64 updateByte(byte value) {
        this.checkSpace(8);
        long v = ((long)value & 0xFFL) << this.bitPos;
        int n = this.stripePos;
        this.stripe[n] = this.stripe[n] | v;
        this.bitPos += 8;
        return this;
    }

    public Hash64 updateBytes(byte[] values, int offset, int length) {
        if (UnsafeUtils.supported() && length >= 8) {
            int i;
            int bytesInStripe = (64 - this.bitPos) / 8;
            int s = offset + bytesInStripe;
            int e = s + (length - bytesInStripe) / 8 * 8;
            for (i = offset; i < s; ++i) {
                this.updateByte(values[i]);
            }
            for (i = s; i < e; i += 8) {
                this.updateLong(UnsafeUtils.getLong(values, i));
            }
            for (i = e; i < offset + length; ++i) {
                this.updateByte(values[i]);
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                this.updateByte(values[i]);
            }
        }
        return this;
    }

    public Hash64 updateBytes(byte[] values) {
        return this.updateBytes(values, 0, values.length);
    }

    public Hash64 updateShort(short value) {
        this.checkSpace(16);
        long v = ((long)value & 0xFFFFL) << this.bitPos;
        int n = this.stripePos;
        this.stripe[n] = this.stripe[n] | v;
        this.bitPos += 16;
        return this;
    }

    public Hash64 updateShorts(short[] values, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.updateShort(values[i]);
        }
        return this;
    }

    public Hash64 updateShorts(short[] values) {
        return this.updateShorts(values, 0, values.length);
    }

    public Hash64 updateInt(int value) {
        this.checkSpace(32);
        long v = ((long)value & 0xFFFFFFFFL) << this.bitPos;
        int n = this.stripePos;
        this.stripe[n] = this.stripe[n] | v;
        this.bitPos += 32;
        return this;
    }

    public Hash64 updateInts(int[] values, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.updateInt(values[i]);
        }
        return this;
    }

    public Hash64 updateInts(int[] values) {
        return this.updateInts(values, 0, values.length);
    }

    public Hash64 updateLong(long value) {
        this.checkSpace(64);
        this.stripe[this.stripePos] = value;
        this.bitPos += 64;
        return this;
    }

    public Hash64 updateLongs(long[] values, int offset, int length) {
        this.checkSpace(64);
        int prefixLength = Math.min(length, this.stripe.length - this.stripePos);
        System.arraycopy(values, offset, this.stripe, this.stripePos, prefixLength);
        this.stripePos += prefixLength;
        if (this.stripePos == this.stripe.length) {
            this.processStripe();
        }
        int start = offset + prefixLength;
        int end = offset + length;
        for (int i = start; i < end; i += this.stripe.length) {
            int copyLength = Math.min(this.stripe.length, end - i);
            System.arraycopy(values, i, this.stripe, 0, copyLength);
            this.stripePos = copyLength;
            if (this.stripePos == this.stripe.length) {
                this.processStripe();
                continue;
            }
            this.stripe[this.stripePos] = 0L;
        }
        return this;
    }

    public Hash64 updateLongs(long[] values) {
        return this.updateLongs(values, 0, values.length);
    }

    public Hash64 updateFloat(float value) {
        return this.updateInt(Float.floatToIntBits(value));
    }

    public Hash64 updateFloats(float[] values, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.updateFloat(values[i]);
        }
        return this;
    }

    public Hash64 updateFloats(float[] values) {
        return this.updateFloats(values, 0, values.length);
    }

    public Hash64 updateDouble(double value) {
        return this.updateLong(Double.doubleToLongBits(value));
    }

    public Hash64 updateDoubles(double[] values, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.updateDouble(values[i]);
        }
        return this;
    }

    public Hash64 updateDoubles(double[] values) {
        return this.updateDoubles(values, 0, values.length);
    }

    private void processStripe() {
        this.inputLength += 32L;
        this.acc1 = this.round(this.acc1, this.stripe[0]);
        this.acc2 = this.round(this.acc2, this.stripe[1]);
        this.acc3 = this.round(this.acc3, this.stripe[2]);
        this.acc4 = this.round(this.acc4, this.stripe[3]);
        this.stripePos = 0;
        this.bitPos = 0;
        this.stripe[0] = 0L;
    }

    private long round(long acc, long lane) {
        acc += lane * -4417276706812531889L;
        acc = Long.rotateLeft(acc, 31);
        return acc * -7046029288634856825L;
    }

    private long mergeAccumulator(long acc, long accN) {
        acc ^= this.round(0L, accN);
        return (acc *= -7046029288634856825L) + -8796714831421723037L;
    }

    private long consumeRemainingInput(long acc) {
        long lane;
        for (int i = 0; i < this.stripePos; ++i) {
            long lane2 = this.stripe[i];
            acc ^= this.round(0L, lane2);
            acc = Long.rotateLeft(acc, 27) * -7046029288634856825L;
            acc += -8796714831421723037L;
        }
        long buffer = this.stripe[this.stripePos];
        if (this.bitPos >= 4) {
            lane = buffer & 0xFFFFFFFFL;
            acc ^= lane * -7046029288634856825L;
            acc = Long.rotateLeft(acc, 23) * -4417276706812531889L;
            acc += 1609587929392839161L;
            buffer >>>= 32;
            this.bitPos -= 4;
        }
        while (this.bitPos >= 1) {
            lane = buffer & 0xFFL;
            acc ^= lane * 2870177450012600261L;
            acc = Long.rotateLeft(acc, 11) * -7046029288634856825L;
            buffer >>>= 8;
            --this.bitPos;
        }
        return acc;
    }

    private long avalanche(long acc) {
        acc ^= acc >>> 33;
        acc *= -4417276706812531889L;
        acc ^= acc >>> 29;
        acc *= 1609587929392839161L;
        acc ^= acc >>> 32;
        return acc;
    }

    public long compute() {
        long acc;
        this.checkSpace(8);
        if (this.inputLength < 32L) {
            acc = this.seed + 2870177450012600261L;
        } else {
            acc = Long.rotateLeft(this.acc1, 1) + Long.rotateLeft(this.acc2, 7) + Long.rotateLeft(this.acc3, 12) + Long.rotateLeft(this.acc4, 18);
            acc = this.mergeAccumulator(acc, this.acc1);
            acc = this.mergeAccumulator(acc, this.acc2);
            acc = this.mergeAccumulator(acc, this.acc3);
            acc = this.mergeAccumulator(acc, this.acc4);
        }
        this.inputLength += (long)this.stripePos * 8L + (long)this.bitPos / 8L;
        acc += this.inputLength;
        acc = this.consumeRemainingInput(acc);
        return this.avalanche(acc);
    }

    public long computeAndReset() {
        long h = this.compute();
        this.reset();
        return h;
    }
}

