/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.TimerBatchUpdater;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public interface Timer
extends Meter {
    public void record(long var1, TimeUnit var3);

    default public void record(Duration amount) {
        this.record(amount.toNanos(), TimeUnit.NANOSECONDS);
    }

    default public void record(long[] amounts, int n, TimeUnit unit) {
        int limit = Math.min(amounts.length, n);
        for (int i = 0; i < limit; ++i) {
            this.record(amounts[i], unit);
        }
    }

    default public void record(Duration[] amounts, int n) {
        int limit = Math.min(amounts.length, n);
        for (int i = 0; i < limit; ++i) {
            this.record(amounts[i]);
        }
    }

    public <T> T record(Callable<T> var1) throws Exception;

    public void record(Runnable var1);

    public long count();

    public long totalTime();

    default public BatchUpdater batchUpdater(int batchSize) {
        return new TimerBatchUpdater(this, batchSize);
    }

    public static interface BatchUpdater
    extends AutoCloseable {
        public void record(long var1, TimeUnit var3);

        default public void record(Duration amount) {
            this.record(amount.toNanos(), TimeUnit.NANOSECONDS);
        }

        public void flush();
    }
}

