/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.Collections;
import spectator-ext-spark.impl.AtomicDouble;

final class DefaultCounter
implements Counter {
    private final Clock clock;
    private final Id id;
    private final AtomicDouble count;

    DefaultCounter(Clock clock, Id id) {
        this.clock = clock;
        this.id = id;
        this.count = new AtomicDouble(0.0);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        double v = this.count.get();
        return Collections.singleton(new Measurement(this.id, now, v));
    }

    @Override
    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.count.addAndGet(amount);
        }
    }

    @Override
    public double actualCount() {
        return this.count.get();
    }
}

