/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.codahale.metrics.MetricRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.gc.GcLogger;
import com.netflix.spectator.jvm.Jmx;
import com.netflix.spectator.spark.SparkNameFunction;
import com.netflix.spectator.spark.SparkValueFunction;
import com.netflix.spectator.spark.SpectatorConfig;
import com.netflix.spectator.spark.SpectatorReporter;
import com.netflix.spectator.stateless.StatelessConfig;
import com.netflix.spectator.stateless.StatelessRegistry;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.spark.SecurityManager;
import org.apache.spark.metrics.sink.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSink
implements Sink {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkSink.class);
    private final SpectatorReporter reporter;
    private final StatelessRegistry statelessRegistry;
    private final long pollPeriod;
    private final TimeUnit pollUnit;
    private GcLogger gcLogger;

    public SparkSink(Properties properties, MetricRegistry registry, SecurityManager manager) throws MalformedURLException {
        Config config = this.loadConfig();
        this.statelessRegistry = new StatelessRegistry(Clock.SYSTEM, (StatelessConfig)new SpectatorConfig(config.getConfig("spectator.spark.stateless")));
        this.reporter = SpectatorReporter.forRegistry(registry).withSpectatorRegistry((Registry)this.statelessRegistry).withNameFunction(SparkNameFunction.fromConfig(config, (Registry)this.statelessRegistry)).withValueFunction(SparkValueFunction.fromConfig(config)).withGaugeCounters(Pattern.compile(config.getString("spectator.spark.gauge-counters"))).build();
        this.pollPeriod = this.getPeriod(properties);
        this.pollUnit = this.getUnit(properties);
        if (this.shouldAddToGlobal(properties)) {
            Spectator.globalRegistry().add((Registry)this.statelessRegistry);
        }
    }

    private Config loadConfig() {
        return ConfigFactory.load((ClassLoader)this.pickClassLoader());
    }

    private ClassLoader pickClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return this.getClass().getClassLoader();
        }
        return cl;
    }

    private void startJvmCollection() {
        try {
            Jmx.registerStandardMXBeans((Registry)this.statelessRegistry);
            this.gcLogger = new GcLogger();
            this.gcLogger.start(null);
        }
        catch (Exception e) {
            LOGGER.error("failed to start collection of jvm stats", (Throwable)e);
            throw e;
        }
    }

    private long getPeriod(Properties properties) {
        String v = properties.getProperty("period");
        return v == null ? 10L : Long.parseLong(v);
    }

    private TimeUnit getUnit(Properties properties) {
        String v = properties.getProperty("unit");
        return v == null ? TimeUnit.SECONDS : TimeUnit.valueOf(v.toUpperCase(Locale.US));
    }

    private boolean shouldAddToGlobal(Properties properties) {
        String v = properties.getProperty("addToGlobalRegistry");
        return v == null || Boolean.parseBoolean(v);
    }

    public void start() {
        LOGGER.info("starting poller");
        this.reporter.start(this.pollPeriod, this.pollUnit);
        this.startJvmCollection();
        if (this.statelessRegistry != null) {
            this.statelessRegistry.start();
        }
    }

    public void stop() {
        LOGGER.info("stopping poller");
        this.reporter.stop();
        this.gcLogger.stop();
        if (this.statelessRegistry != null) {
            this.statelessRegistry.stop();
        }
    }

    public void report() {
        LOGGER.info("reporting values");
        this.reporter.report();
    }
}

