/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.jvm;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HotspotRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(HotspotRuntime.class);
    private static Class<?> runtimeMBeanType;
    private static Object runtimeMBean;
    private static Method safepointCount;
    private static Method safepointTime;
    private static Method safepointSyncTime;

    private HotspotRuntime() {
    }

    private static Method getMethod(String name) throws Exception {
        Method method = runtimeMBeanType.getMethod(name, new Class[0]);
        method.invoke(runtimeMBean, new Object[0]);
        return method;
    }

    private static long getValue(Method method) {
        if (runtimeMBean == null) {
            throw new UnsupportedOperationException("HotspotRuntime is not supported");
        }
        try {
            return (Long)method.invoke(runtimeMBean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to invoke " + method, e);
        }
    }

    static Object getRuntimeMBean() {
        return runtimeMBean;
    }

    static boolean isSupported() {
        return runtimeMBean != null;
    }

    static long getSafepointCount() {
        return HotspotRuntime.getValue(safepointCount);
    }

    static long getSafepointTime() {
        return HotspotRuntime.getValue(safepointTime);
    }

    static long getSafepointSyncTime() {
        return HotspotRuntime.getValue(safepointSyncTime);
    }

    static {
        try {
            runtimeMBeanType = Class.forName("sun.management.HotspotRuntimeMBean");
            runtimeMBean = Class.forName("sun.management.ManagementFactoryHelper").getMethod("getHotspotRuntimeMBean", new Class[0]).invoke(null, new Object[0]);
            safepointCount = HotspotRuntime.getMethod("getSafepointCount");
            safepointTime = HotspotRuntime.getMethod("getTotalSafepointTime");
            safepointSyncTime = HotspotRuntime.getMethod("getSafepointSyncTime");
        }
        catch (Exception e) {
            LOGGER.debug("unable to access HotspotRuntimeMBean", (Throwable)e);
            runtimeMBean = null;
        }
    }
}

