/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.stateless.StatelessConfig;
import com.typesafe.config.Config;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

class SpectatorConfig
implements StatelessConfig {
    private final Config config;

    SpectatorConfig(Config config) {
        this.config = config;
    }

    public String get(String k) {
        return this.config.hasPath(k) ? this.config.getString(k) : null;
    }

    public boolean enabled() {
        return this.config.getBoolean("enabled");
    }

    public Duration meterTTL() {
        return this.config.getDuration("meter-ttl");
    }

    public Duration frequency() {
        return this.config.getDuration("frequency");
    }

    public Duration connectTimeout() {
        return this.config.getDuration("connect-timeout");
    }

    public Duration readTimeout() {
        return this.config.getDuration("read-timeout");
    }

    public String uri() {
        return this.config.getString("uri");
    }

    public int batchSize() {
        return this.config.getInt("batch-size");
    }

    public Map<String, String> commonTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Config cfg : this.config.getConfigList("tags")) {
            String value = cfg.getString("value");
            if (value.isEmpty()) continue;
            tags.put(cfg.getString("key"), cfg.getString("value"));
        }
        return tags;
    }
}

