/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.spark.ValueFunction;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class SparkValueFunction
implements ValueFunction {
    private final List<NameMatcher> matchers;

    public static SparkValueFunction fromConfig(Config config) {
        return SparkValueFunction.fromConfig(config, "spectator.spark.value-conversions");
    }

    public static SparkValueFunction fromConfig(Config config, String key) {
        return SparkValueFunction.fromPatternList(config.getConfigList(key));
    }

    private static SparkValueFunction fromPatternList(List<? extends Config> patterns) {
        ArrayList<NameMatcher> matchers = new ArrayList<NameMatcher>();
        for (Config config : patterns) {
            Pattern pattern = Pattern.compile(config.getString("pattern"));
            matchers.add(new NameMatcher(pattern, config.getDouble("factor")));
        }
        return new SparkValueFunction(matchers);
    }

    private SparkValueFunction(List<NameMatcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public double convert(String name, double v) {
        for (NameMatcher matcher : this.matchers) {
            if (!matcher.matches(name)) continue;
            return matcher.apply(v);
        }
        return v;
    }

    private static class NameMatcher {
        private final Pattern pattern;
        private final double factor;

        NameMatcher(Pattern pattern, double factor) {
            this.pattern = pattern;
            this.factor = factor;
        }

        boolean matches(String name) {
            return this.pattern.matcher(name).matches();
        }

        double apply(double v) {
            return Math.abs(v + 1.0) <= 1.0E-12 ? Double.NaN : v * this.factor;
        }
    }
}

