/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.spark.NameFunction;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SparkNameFunction
implements NameFunction {
    private static final String PREFIX = "spark.";
    private static final Id DROP_METRIC = null;
    private final List<NameMatcher> matchers;

    public static SparkNameFunction fromConfig(Config config, Registry registry) {
        return SparkNameFunction.fromConfig(config, "spectator.spark.name-patterns", registry);
    }

    public static SparkNameFunction fromConfig(Config config, String key, Registry registry) {
        return SparkNameFunction.fromPatternList(config.getConfigList(key), registry);
    }

    private static SparkNameFunction fromPatternList(List<? extends Config> patterns, Registry registry) {
        ArrayList<NameMatcher> matchers = new ArrayList<NameMatcher>();
        for (Config config : patterns) {
            Pattern pattern = Pattern.compile(config.getString("pattern"));
            LinkedHashMap<String, Integer> tagsMap = new LinkedHashMap<String, Integer>();
            Config tagsCfg = config.getConfig("tags");
            for (Map.Entry entry : tagsCfg.entrySet()) {
                tagsMap.put((String)entry.getKey(), (Integer)((ConfigValue)entry.getValue()).unwrapped());
            }
            matchers.add(new NameMatcher(pattern, registry, config.getInt("name"), tagsMap));
        }
        return new SparkNameFunction(matchers);
    }

    private SparkNameFunction(List<NameMatcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public Id apply(String name) {
        for (NameMatcher matcher : this.matchers) {
            Id id = matcher.apply(name);
            if (id == DROP_METRIC) continue;
            return id;
        }
        return DROP_METRIC;
    }

    private static class NameMatcher {
        private final Pattern pattern;
        private final Registry registry;
        private final int name;
        private final Map<String, Integer> tags;

        NameMatcher(Pattern pattern, Registry registry, int name, Map<String, Integer> tags) {
            this.pattern = pattern;
            this.registry = registry;
            this.name = name;
            this.tags = tags;
        }

        Id apply(String metric) {
            Matcher m = this.pattern.matcher(metric);
            if (m.matches()) {
                Id id = this.registry.createId(SparkNameFunction.PREFIX + m.group(this.name));
                for (Map.Entry<String, Integer> entry : this.tags.entrySet()) {
                    id = id.withTag(entry.getKey(), m.group(entry.getValue()));
                }
                if (!this.tags.containsKey("role")) {
                    id = id.withTag("role", "executor");
                }
                return id;
            }
            return DROP_METRIC;
        }
    }
}

