/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;

abstract class StatelessMeter
implements Meter {
    protected final Id id;
    protected final Clock clock;
    private final long ttl;
    private volatile long lastUpdated;

    StatelessMeter(Id id, Clock clock, long ttl) {
        this.id = id;
        this.clock = clock;
        this.ttl = ttl;
        this.lastUpdated = clock.wallTime();
    }

    void updateLastModTime() {
        this.lastUpdated = this.clock.wallTime();
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return this.clock.wallTime() - this.lastUpdated > this.ttl;
    }
}

