/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.stateless.StatelessMeter;
import java.util.Collections;

class StatelessMaxGauge
extends StatelessMeter
implements Gauge {
    private final AtomicDouble value = new AtomicDouble(Double.NaN);
    private final Id stat;

    StatelessMaxGauge(Id id, Clock clock, long ttl) {
        super(id, clock, ttl);
        this.stat = id.withTag(Statistic.max).withTags(id.tags());
    }

    @Override
    public void set(double v) {
        this.value.max(v);
        this.updateLastModTime();
    }

    @Override
    public double value() {
        return this.value.get();
    }

    @Override
    public Iterable<Measurement> measure() {
        double delta = this.value.getAndSet(Double.NaN);
        if (Double.isFinite(delta)) {
            Measurement m = new Measurement(this.stat, this.clock.wallTime(), delta);
            return Collections.singletonList(m);
        }
        return Collections.emptyList();
    }
}

