/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.stateless.StatelessConfig;
import com.typesafe.config.Config;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

class SpectatorConfig
implements StatelessConfig {
    private final Config config;

    SpectatorConfig(Config config) {
        this.config = config;
    }

    @Override
    public String get(String k) {
        return this.config.hasPath(k) ? this.config.getString(k) : null;
    }

    @Override
    public boolean enabled() {
        return this.config.getBoolean("enabled");
    }

    @Override
    public Duration meterTTL() {
        return this.config.getDuration("meter-ttl");
    }

    @Override
    public Duration frequency() {
        return this.config.getDuration("frequency");
    }

    @Override
    public Duration connectTimeout() {
        return this.config.getDuration("connect-timeout");
    }

    @Override
    public Duration readTimeout() {
        return this.config.getDuration("read-timeout");
    }

    @Override
    public String uri() {
        return this.config.getString("uri");
    }

    @Override
    public int batchSize() {
        return this.config.getInt("batch-size");
    }

    @Override
    public Map<String, String> commonTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Config config : this.config.getConfigList("tags")) {
            String value = config.getString("value");
            if (value.isEmpty()) continue;
            tags.put(config.getString("key"), config.getString("value"));
        }
        return tags;
    }
}

