/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stateless;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.stateless.StatelessMeter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongToDoubleFunction;

class StatelessDistributionSummary
extends StatelessMeter
implements DistributionSummary {
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong totalAmount = new AtomicLong(0L);
    private final AtomicDouble totalOfSquares = new AtomicDouble(0.0);
    private final AtomicLong max = new AtomicLong(0L);
    private final Id[] stats;

    StatelessDistributionSummary(Id id, Clock clock, long ttl) {
        super(id, clock, ttl);
        this.stats = new Id[]{id.withTags(Statistic.count), id.withTags(Statistic.totalAmount), id.withTags(Statistic.totalOfSquares), id.withTags(Statistic.max)};
    }

    @Override
    public void record(long amount) {
        if (amount >= 0L) {
            this.count.incrementAndGet();
            this.totalAmount.addAndGet(amount);
            this.totalOfSquares.addAndGet(1.0 * (double)amount * (double)amount);
            this.updateMax(amount);
            this.updateLastModTime();
        }
    }

    private void updateMax(long v) {
        long p = this.max.get();
        while (v > p && !this.max.compareAndSet(p, v)) {
            p = this.max.get();
        }
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public long totalAmount() {
        return this.totalAmount.get();
    }

    @Override
    public Iterable<Measurement> measure() {
        if (this.count.get() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> ms = new ArrayList<Measurement>(4);
        ms.add(this.newMeasurement(this.stats[0], this.count::getAndSet));
        ms.add(this.newMeasurement(this.stats[1], this.totalAmount::getAndSet));
        ms.add(this.newMeasurement(this.stats[2], this.totalOfSquares::getAndSet));
        ms.add(this.newMeasurement(this.stats[3], this.max::getAndSet));
        return ms;
    }

    private Measurement newMeasurement(Id mid, LongToDoubleFunction getAndSet) {
        double delta = getAndSet.applyAsDouble(0L);
        long timestamp = this.clock.wallTime();
        return new Measurement(mid, timestamp, delta);
    }
}

