/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.jvm;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.jvm.JmxData;
import com.netflix.spectator.jvm.MappingExpr;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.management.ObjectName;

final class JmxMeasurementConfig {
    private final String nameMapping;
    private final Map<String, String> tagMappings;
    private final String valueMapping;
    private final boolean counter;
    private final Map<ObjectName, JmxData> previousData;
    private final Map<Id, AtomicLong> previousCount;

    static JmxMeasurementConfig from(Config config) {
        String name = config.getString("name");
        Map<String, String> tags = config.getConfigList("tags").stream().collect(Collectors.toMap(c -> c.getString("key"), c -> c.getString("value")));
        String value = config.getString("value");
        boolean counter = config.hasPath("counter") && config.getBoolean("counter");
        return new JmxMeasurementConfig(name, tags, value, counter);
    }

    JmxMeasurementConfig(String nameMapping, Map<String, String> tagMappings, String valueMapping, boolean counter) {
        this.nameMapping = nameMapping;
        this.tagMappings = tagMappings;
        this.valueMapping = valueMapping;
        this.counter = counter;
        this.previousData = new ConcurrentHashMap<ObjectName, JmxData>();
        this.previousCount = new ConcurrentHashMap<Id, AtomicLong>();
    }

    void measure(Registry registry, JmxData data) {
        Double v;
        Map<String, String> tags = this.tagMappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> MappingExpr.substitute((String)e.getValue(), data.getStringAttrs())));
        Id id = registry.createId(MappingExpr.substitute(this.nameMapping, data.getStringAttrs())).withTags(tags);
        HashMap<String, Number> numberAttrs = new HashMap<String, Number>(data.getNumberAttrs());
        JmxData previous = this.previousData.put(data.getName(), data);
        if (previous != null) {
            previous.getNumberAttrs().forEach((key, value) -> numberAttrs.put("previous:" + key, (Number)value));
        }
        if ((v = MappingExpr.eval(this.valueMapping, numberAttrs)) != null && !v.isNaN()) {
            if (this.counter) {
                this.updateCounter(registry, id, v.longValue());
            } else {
                registry.gauge(id).set(v);
            }
        }
    }

    private void updateCounter(Registry registry, Id id, long v) {
        long p;
        AtomicLong prev = this.previousCount.computeIfAbsent(id, i -> new AtomicLong(Long.MIN_VALUE));
        if (prev.compareAndSet(p = prev.get(), v) && p != Long.MIN_VALUE) {
            registry.counter(id).increment(v - p);
        }
    }
}

