/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.spark.DataType;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class SidecarTimer
implements Timer {
    private static final int MAX_VALUES = 10000;
    private final Clock clock;
    private final Id id;
    private final LinkedBlockingQueue<Measurement> values = new LinkedBlockingQueue(10000);

    SidecarTimer(Clock clock, Id id) {
        this.clock = clock;
        this.id = id.withTag((Tag)DataType.TIMER);
    }

    public Id id() {
        return this.id;
    }

    public void record(long amount, TimeUnit unit) {
        Measurement m = new Measurement(this.id, this.clock.wallTime(), (double)unit.toMillis(amount));
        this.values.offer(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T record(Callable<T> f) throws Exception {
        long start = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(Runnable f) {
        long start = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public long count() {
        return 0L;
    }

    public long totalTime() {
        return 0L;
    }

    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        this.values.drainTo(ms);
        return ms;
    }

    public boolean hasExpired() {
        return false;
    }
}

