/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.spark.DataType;
import java.util.Collections;

class SidecarGauge
implements Gauge {
    private final Clock clock;
    private final Id id;
    private final AtomicDouble value;

    SidecarGauge(Clock clock, Id id) {
        this.clock = clock;
        this.id = id.withTag((Tag)DataType.COUNTER);
        this.value = new AtomicDouble(0.0);
    }

    public Id id() {
        return this.id;
    }

    public void set(double v) {
        this.value.set(v);
    }

    public double value() {
        return this.value.get();
    }

    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.id, this.clock.wallTime(), this.value());
        return Collections.singletonList(m);
    }

    public boolean hasExpired() {
        return false;
    }
}

