/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.spark.DataType;
import java.util.Collections;

class SidecarCounter
implements Counter {
    private final Clock clock;
    private final Id id;
    private final AtomicDouble value;

    SidecarCounter(Clock clock, Id id) {
        this.clock = clock;
        this.id = id.withTag(DataType.COUNTER);
        this.value = new AtomicDouble(0.0);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.value.addAndGet(amount);
        }
    }

    @Override
    public double actualCount() {
        return this.value.get();
    }

    @Override
    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.id, this.clock.wallTime(), this.value.getAndSet(0.0));
        return Collections.singletonList(m);
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

