/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.jvm;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.jvm.JmxConfig;
import com.netflix.spectator.jvm.JmxData;
import com.netflix.spectator.jvm.JmxMeasurementConfig;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JmxMeter
implements Meter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMeter.class);
    private final Registry registry;
    private final JmxConfig config;
    private final Id id;

    JmxMeter(Registry registry, JmxConfig config) {
        this.registry = registry;
        this.config = config;
        this.id = registry.createId(config.getQuery().getCanonicalName());
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        try {
            for (JmxData data : JmxData.query(this.config.getQuery())) {
                for (JmxMeasurementConfig cfg : this.config.getMeasurements()) {
                    cfg.measure(this.registry, data, ms);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to query jmx data: {}", (Object)this.config.getQuery().getCanonicalName(), (Object)e);
        }
        return ms;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

